//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RVBitmap.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.1
//
// Modification History:
//  Dec/05/1998:	Created	
//  Feb/27/1999:	Modified setBitmap()
//
// Bugs:
//
//-------------------------------------------------------------------=72

#define _RV_BITMAP_C

#include "stdafx.h"

#include "RVBitmap.h"

//#define EQUALIZE_WHOLE

RVBitmap::RVBitmap()
:WGLObject(),
 mEqualized(false),
 mBitmap()
{}

RVBitmap::RVBitmap(
			const RVBitmap& x)
:WGLObject(x),
 mEqualized(x.mEqualized),
 mBitmap(x.mBitmap)
{}

RVBitmap::~RVBitmap()
{}

const RVBitmap& RVBitmap::operator=(
			const RVBitmap& x)
{
	WGLObject::operator=(x);
	mEqualized=x.mEqualized;
	mBitmap=x.mBitmap;
	return *this; 
}

bool RVBitmap::setBitmap(
			const RVDoc *doc)
{
	int xs,ys,depth;
	doc->mUDP.getSize(xs,ys,depth);
	//unsigned char *bmp = new unsigned char[xs*ys*depth];
	RRBoundingBox bbox(RRGrid2(0,0),RRGrid2(xs,ys),0);
	if(!(bbox==mBitmap.getBBox()) ||
	   depth!=mBitmap.getDepth())
		mBitmap.setDimension(bbox,depth);
	unsigned char * const bmp=mBitmap.getBitmap();

	if(mEqualized)
	{
		if(doc->mUDP.getLocalRadianceBitmap(0,0,xs,ys,depth,bmp)==false)
		{
			//delete[] bmp;
			return false;
		}
	}
	else
	{
		if(doc->mUDP.getBitmap(0,0,xs,ys,depth,bmp)==false)
		{
			//delete[] bmp;
			return false;
		}
	}

	//RRBoundingBox bbox(RRGrid2(0,0),RRGrid2(xs,ys),0);
	//mBitmap=WGLBitmap(bbox,depth,bmp);
	//delete[] bmp;
	return true;
}

bool RVBitmap::renderObject()const
{
	glPushMatrix();
	{
		mBitmap.renderObject();
	}
	glPopMatrix();

	return true;
}

//-------------------------------------------------------------------=72
// End of RVBitmap.cpp
//-------------------------------------------------------------------=72
