//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// rawtoppm16.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
// Date:                 Jun/01/1999
// Version:              1.0
//
// Modification History:
//  Jun/01/1999:	Created	
//
// Bugs:
//
//
//-------------------------------------------------------------------=72
//	
// rawtoppm16 <inimage> <width> <height> <outimage>
//
// inimage:		file name of input raw image.
// width:		width of the image.
// height:		height of the image.
// outimage:	file name of output ppm2 image.
//
// rawtoppm16 converts a 16bit raw format image to a ppm16 format image.
// raw format must be created as followings
//		- No header,
//		- RGB 3channel,
//		- 16bit per channel,   
//		- Interleaved (R followed by G followed by B in a pixel),
//		- binary with IBM-PC byte order.
//
//-------------------------------------------------------------------=72

#include "RRPPM16Image.h"
#include "RRRAWImage.h"

#include <stdio.h>
#include <string.h>


int main(
			int argc,
			char *argv[])
{
	char infile[256],outfile[256];
	int width,height;

	if(argc!=5)
	{
		//printf("usage: rawtoppm16 <inimage> <width> <height> <outimage>\n"); 
		//return 0; // normal ending

		char buf[256];
		printf("inimage ...\n");
		gets(buf);
		sscanf(buf,"%s",infile);

		printf("width ...\n");
		gets(buf);
		sscanf(buf,"%d",&width);

		printf("height ...\n");
		gets(buf);
		sscanf(buf,"%d",&height);

		printf("outimage ...\n");
		gets(buf);
		sscanf(buf,"%s",outfile);
	}
	else
	{
		strcpy(infile,argv[1]);
		strcpy(outfile,argv[4]);
		sscanf(argv[2],"%d",&width);
		sscanf(argv[3],"%d",&height);
	}

	RRRORAWImage raw(infile,width,height);
	RRWOPPM16Image ppm(outfile);
	ppm.RRPPM16Image::operator=(raw);

	printf("Process successfully ended.\n");
	return 0;
}

//-------------------------------------------------------------------=72
// End of rawtoppm16.cpp
//-------------------------------------------------------------------=72
