//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRRAWImage.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Jun/01/1999:	Created
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//-------------------------------------------------------------------=72

#ifndef _RR_RAW_IMAGE_H
#define _RR_RAW_IMAGE_H

#include "RRDef.h"
#include "RRImage.h"
#include "RRPixelS.h"
#include "RRPPM16Image.h"

class RRRAWImage : public RRPPM16Image
{
  private:

  private:

  public:

	RRRAWImage(const char *filename);
	RRRAWImage(const char *filename, const RRImage< RRPixelS >& v);
	virtual ~RRRAWImage();

	RRStatus save();
	RRStatus load();

	const RRRAWImage& operator=(const RRRAWImage& v);
	friend bool operator==(const RRRAWImage& v1,const RRRAWImage& v2);
	friend bool operator!=(const RRRAWImage& v1,const RRRAWImage& v2);
};


class RRRORAWImage : public RRRAWImage
{
  protected:

	RRStatus save();

	const RRRAWImage& operator=(const RRRAWImage& v);
	const RRImage< RRPixelS >& operator=(const RRImage< RRPixelS >& v);

  public:

    RRRORAWImage(
			const char *filename,
			const int width,
			const int height);

    virtual ~RRRORAWImage(){}
};

class RRWORAWImage : public RRRAWImage
{
  protected:

	RRStatus load();

  public:

    RRWORAWImage(const char *filename):RRRAWImage(filename)
	{}

    virtual ~RRWORAWImage(){save();}

	const RRRAWImage& operator=(const RRRAWImage& v)
	{return RRRAWImage::operator=(v);}
	
	const RRImage< RRPixelS >& operator=(const RRImage< RRPixelS >& v)
	{return RRImage< RRPixelS >::operator=(v);}
};


    
#endif // _RR_PPM16_IMAGE_H

//-------------------------------------------------------------------=72
// End of RRRAWImage.h
//-------------------------------------------------------------------=72
