//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRRAWImage.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Jun/01/1999:	Created
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "RRRAWImage.h"

#include <stdio.h>
#include <string.h>

RRRAWImage::RRRAWImage(const char *filename)
:RRPPM16Image(filename)
{}

RRRAWImage::RRRAWImage(const char *filename, const RRImage< RRPixelS >& v)
:RRPPM16Image(filename,v)
{}

RRRAWImage::~RRRAWImage(){}

RRStatus RRRAWImage::save()
{ // do not save header
	const int numsavechannels = 3; // RGB only (no A chan)

	FILE *fp = fopen(fileName,"wb");
	if(fp==NULL)
		return RR_ERROR;

	int x,y;
	getSize(x,y);

	int rowsize=x*numsavechannels;
	int size=rowsize*y;
	unsigned short *bits = new unsigned short[size];
	unsigned short *row = new unsigned short[rowsize];

	getRawBits(numsavechannels,bits);
	for(int i=0;i<y;i++)
	{
		int offset=rowsize*(y-i-1);
		memcpy(row,bits+offset,rowsize*sizeof(unsigned short));
		int nr=fwrite(row,sizeof(unsigned short),rowsize,fp);
		assert(nr==rowsize);
	}

	fclose(fp);
	delete[] bits;
	delete[] row;
	return RR_SUCCESS;
}

RRStatus RRRAWImage::load()
{
	const int numsavechannels = 3; // RGB only (no A chan)

	FILE *fp = fopen(fileName,"rb");
	if(fp==NULL)
		return RR_ERROR;

	int x,y;
	getSize(x,y);

	// check the file size
	fseek(fp,0L,SEEK_END);
	long fsize = ftell(fp);
	fseek(fp,0L,SEEK_SET);
	fsize = fsize-ftell(fp);
	const long isize = x*y*numsavechannels*sizeof(unsigned short);
	if(fsize!=isize)
		return RR_ERROR;

	rewind(fp);
	
	int rowsize=x*numsavechannels;
	int size=rowsize*y;
	unsigned short *bits = new unsigned short[size];
	unsigned short *row = new unsigned short[rowsize];

	for(int i=0;i<y;i++)
	{
		int nr=fread(row,sizeof(unsigned short),rowsize,fp);
		assert(nr==rowsize);
		int offset=rowsize*(y-i-1);
		memcpy(bits+offset,row,rowsize*sizeof(unsigned short));
	}
	setRawBits(numsavechannels,bits);

	fclose(fp);
	delete[] bits;
	delete[] row;
	return RR_SUCCESS;
}

const RRRAWImage& RRRAWImage::operator=(const RRRAWImage& v)
{
	RRImage< RRPixelS >::operator=(v);
	//strcpy(fileName,v.fileName);
	return *this;
}

bool operator==(const RRRAWImage& v1,const RRRAWImage& v2)
{
	return (operator==((const RRImage< RRPixelS >&)v1,(const RRImage< RRPixelS >&)v2) &&
			!strcmp(v1.fileName,v2.fileName))?true:false;
}

bool operator!=(const RRRAWImage& v1,const RRRAWImage& v2)
{
	return (operator!=((const RRImage< RRPixelS >&)v1,(const RRImage< RRPixelS >&)v2) ||
			strcmp(v1.fileName,v2.fileName))?true:false;
}

RRRORAWImage::RRRORAWImage(
			const char *filename,
			const int width,
			const int height)
:RRRAWImage(filename)
{
	setSize(width,height);
	load();
}

//-------------------------------------------------------------------=72
// End of RRRAWImage.cpp
//-------------------------------------------------------------------=72
