//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRSpatialPixelAverageProc.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldSpatialPixelAverage.h
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RRSpatialPixelAverageProc computes spatial average. 
//
//	in[0]:	RRPixelStatisticsData
//			imput image which stored with double precision.
//	in[1]:	RRSelectParamData
//			parameters. this is commonly used with RRSelcetProc.
//	out:	RRPixelStatisticsData		
//			output averaging results
//	
//	At each pixel, a NxN sized averaging filter is applied. N is 
//	specified by the kernelSize parameter of RRSelectParamData. Both 
//	mean value and variance value at every pixel are stored in 
//	RRPixelStatisticsData.
// 
//-------------------------------------------------------------------=72

#ifndef _RR_SPATIAL_PIXEL_AVERAGE_PROC_H
#define _RR_SPATIAL_PIXEL_AVERAGE_PROC_H

#include "RRProcess.h"
#include "RRPixelStatisticsData.h"
#include "RRSelectParamData.h"

extern const int RRSPAP_KERNEL_SIZE;

class RRSpatialPixelAverageProc : public RRProcess
{
  private:

	int mKernelSize;
	int mKernelHalfSize;
	int mNumPixelsOfKernel;

  private:
  
  	RRStatus mfSetKernelSize(const int kernel);

	void mfGetWin(
			const RRField< double >& img,
			const int x,
			const int y,
			double* w);
	void mfCalcMeanAndVariance(
			const double *w,
			double& m,
			double& v);

  public:

    RRSpatialPixelAverageProc(
			const RRArray< RRData* >& in,	
					// in[0]: RRPixelStatisticsData
					//	imput image
					// in[1]: RRSelectParamData
					//	parameters
			RRData *out);	
					// out: RRPixelStatisticsData		
					//	output image

	RRStatus doIt();
	// execute operation.
};

#endif // _RR_SPATIAL_PIXEL_AVERAGE_PROC_H

//-------------------------------------------------------------------=72
// End of RRSpatialPixelAverageProc.h
//-------------------------------------------------------------------=72
