//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRSpatialPixelAverageProc.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
// Date:                 Oct/27/1998
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldSpatialPixelAverage.cpp
//
// Bugs:
//
// Classes:
//
// Notes:
//
//-------------------------------------------------------------------=72

#include "RRSpatialPixelAverageProc.h"

const int RRSPAP_KERNEL_SIZE = 3;

RRSpatialPixelAverageProc::RRSpatialPixelAverageProc(
			const RRArray< RRData* >& in,	
					// in[0]: RRPixelStatisticsData
					//	imput image
					// in[1]: RRSelectParamData
					//	parameters
			RRData *out)	
					// out: RRPixelStatisticsData		
					//	output image
:RRProcess("RRSpatialPixelAverageProc",in,out)
{}

RRStatus RRSpatialPixelAverageProc::mfSetKernelSize(
			const int kernel)
{
	if(kernel%2==0)
		return RR_ERROR;

	mKernelSize=kernel;
	mKernelHalfSize=kernel/2;
	mNumPixelsOfKernel=kernel*kernel;
	return RR_SUCCESS;
}

void RRSpatialPixelAverageProc::mfGetWin(
			const RRField< double >& img,
			const int x,
			const int y,
			double* w)
{
	int xs,ys;
    img.getSize(xs,ys);

 	double pxl;
    int py=y-mKernelHalfSize,ik=0;
	for(int i=0;i<mKernelSize;i++)
    {
		int px=x-mKernelHalfSize;
		for(int j=0;j<mKernelSize;j++)
		{    
			if(px<0 || px>=xs || py<0 || py>=ys)
				pxl = 0.;
			else
				pxl = img.getElem(px,py);
			
			w[ik+j]=pxl;
			
			px++;
		}
		py++;
		ik+=mKernelSize;
    }
    return;
}

void RRSpatialPixelAverageProc::mfCalcMeanAndVariance(
			const double *w,
			double& m,
			double& v)
{
	m=0.;
	double mm=0.;
	for(int i=0;i<mNumPixelsOfKernel;i++)
	{
		m+=w[i];
		mm+=w[i]*w[i];
	}
	m/=mNumPixelsOfKernel;
	v=mm/mNumPixelsOfKernel-m*m;
}

RRStatus RRSpatialPixelAverageProc::doIt()
{
	const RRPixelStatisticsData& in=(const RRPixelStatisticsData&)mInput[0]->getSubstance();
	const RRField< double >& img=in.getAllMean();

	const RRSelectParamData& param=(const RRSelectParamData&)mInput[1]->getSubstance();
	if(mfSetKernelSize(param.getKernelSize())==RR_ERROR)
		mfSetKernelSize(RRSPAP_KERNEL_SIZE);

	int xs,ys;
	img.getSize(xs,ys);

	if(xs==0 || ys==0)
		return RR_ERROR;

	RRField< double > mean(xs,ys,0.);
	RRField< double > var(xs,ys,0.);

	double *w = new double[mNumPixelsOfKernel];
	for(int y=0;y<ys;y++)
		for(int x=0;x<xs;x++)
		{
			double m,v;
			mfGetWin(img,x,y,w);
			mfCalcMeanAndVariance(w,m,v);
			mean.setElem(x,y,m);
			var.setElem(x,y,v);
		}
	delete[] w;

	RRPixelStatisticsData& out=(RRPixelStatisticsData&)mOutput->getSubstance();
	out.setAllMeanAndVariance(mean,var);

	return RR_SUCCESS;
}

/*
RRStatus RRSpatialPixelAverageProc::writeMeanImageTo(
			RRImage& img)
{
	RRPixelStatisticsData& subs=(RRPixelStatisticsData&)output->getSubstance();
	const RRField< double >& mean=subs.getAllMean();

	int xs,ys;
	mean.getSize(xs,ys);
	
	if(xs==0 || ys==0)
		return RR_ERROR;

	img.setSize(xs,ys);

	for(int y=0;y<ys;y++)
		for(int x=0;x<xs;x++)
		{
			double v=mean.getElem(x,y);
			img.setPixRR(x,y,RRPixRR(v,v,v,1.));
		}

	return RR_SUCCESS;
}
       
RRStatus RRSpatialPixelAverageProc::writeVarianceImageTo(
			RRImage& img)
{
	RRPixelStatisticsData& subs=(RRPixelStatisticsData&)output->getSubstance();
	const RRField< double >& var=subs.getAllVariance();

	int xs,ys;
	var.getSize(xs,ys);

	if(xs==0 || ys==0)
		return RR_ERROR;

	img.setSize(xs,ys);

	double maxvar=0.;
	for(int y=0;y<ys;y++)
		for(int x=0;x<xs;x++)
		{
			double v=var.getElem(x,y);
			maxvar=(v>maxvar)?v:maxvar;
		}

	for(y=0;y<ys;y++)
		for(int x=0;x<xs;x++)
		{
			double v=var.getElem(x,y)/maxvar;
			img.setPixRR(x,y,RRPixRR(v,v,v,1.));
		}

	return RR_SUCCESS;
}
*/

//-------------------------------------------------------------------=72
// End of RRSpatialPixelAverageProc.cpp
//-------------------------------------------------------------------=72
