//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRSelectProc.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldSelectLowVariance.h
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RRSelectProc selects pixels which is good for radiance recovery.
//
//	in[0]:	RRPixelStatisticsData
//			temporal average of im0
//	in[1]:	RRPixelStatisticsData
//			temporal average of im1
//	in[2]:	RRPixelStatisticsData
//			spatial average of im0
//	in[3]:	RRPixelStatisticsData
//			spatial average of im1
//	in[4]:	RRSelectParamData
//			parameters
//	out:	RR2DDoubleArrayData
//			array of selected pixel values
//
//	After obtaining both temporal and spatial averaging of 2 images,
//	good pixel pairs are selected from 2 images by RRSelectProc.
//	3 types of selection criterion are used.
//	(1) Selection by trimming
//		Pixels at side area are rejected because they might be distorted 
//		by vegnetting.
//	(2) Slection by limitting
//		Saturated and black-out pixels are rejected.
//	(3) Selection by noise test
//		Pixels which have high temporal or spatial variance are rejected
//		by a statistical test. 
//	Then, selected pixel pairs are sampled so that they uniformly 
//	distribute from 0 to 1.
//
//	Parameters for this process are defined in RRSelectParamData.
//	See RRSelectParamData.h for detail. 
//
//-------------------------------------------------------------------=72

#ifndef _RR_SELECT_PROC_H
#define _RR_SELECT_PROC_H

#include "RRProcess.h"
#include "RRField.h"
#include "RRPixelStatisticsData.h"
#include "RR2DDoubleArrayData.h"
#include "RRSelectParamData.h"

class RRSelectProc : public RRProcess
{
  private:

	double mTrimRatio;
	double mSaturationLevel;
	double mNoiseLevel;
	int mMaxSamplingNum;
	int mKernelSize;

  private:

	RRStatus mfSelectByTrimming(
			RRField< int >& select);
	RRStatus mfSelectBySampling(
			RRField< int >& select);
	RRStatus mfSelectByLimitting(
			const RRField< double >& mean,
			RRField< int >& select);
	RRStatus mfSelectByNoiseVarianceTest(
			const RRField< double >& variance,
			const RRField< double >& noise,
			RRField< int >& select);
	RRStatus mfSelectPixels(
			const RRField< double >& mean,
			const RRField< double >& variance,
			const RRField< double >& noise,
			RRField< int >& select);
	RRStatus mfMakeImArray(
			const RRField< double >& mean0,
			const RRField< double >& mean1,
			const RRField< int >& select0,
			const RRField< int >& select1,
			RRArray< RRArray< double > >& im);

  public:

    RRSelectProc(
			const RRArray< RRData* >& in,	
									// in0 : RRPixelStatisticsData
									//	temporal average of im0
									// in1 : RRPixelStatisticsData
									//	temporal average of im1
									// in2 : RRPixelStatisticsData
									//	spatial average of im0
									// in3 : RRPixelStatisticsData
									//	spatial average of im1
									// in4 : RRSelectParamData
									//	parameters
			RRData *out);			// RR2DDoubleArrayData

	RRStatus doIt();
	// execute operation
};

#endif // _RR_SELECT_PROC_H

//-------------------------------------------------------------------=72
// End of RRSelectLowVariance.h
//-------------------------------------------------------------------=72
