//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRSelectAutoTrimProc.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Apr/02/1999:	Created
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RRSelectAutoTrimProc selects pixels which are good for radiance 
//	recovery. 
//
//	in[0]:	RRPixelStatisticsData
//			temporal average of im0
//	in[1]:	RRPixelStatisticsData
//			temporal average of im1
//	in[2]:	RRPixelStatisticsData
//			spatial average of im0
//	in[3]:	RRPixelStatisticsData
//			spatial average of im1
//	in[4]:	RRSelectParamData
//			parameters
//	out:	RR2DDoubleArrayData
//			array of selected pixel values
//
//	Unlike RRSelectProc, RRSelectAutoTrimProc automatically adjust the
//	trimming size (auto-trimming).
//	The auto-trimming is computed as the following proccess.
//	(1) Trimming size is initialized to 1 (means no trimming).
//	(2) Pixel selection is computed with same way as RRSelectProc's.
//	(3) Selected pixels are plotted onto im0-im1 space.
//	(4) Spline curve is fitted to the im0-im1 plot.
//	(5) If the fitting error is large, (2)-(4) is repeated with smaller 
//		trimming size.
//	(6) When the fitting error becomes smaller than a criterion, process
//		ends.  
//
//	See RRSelectProc.h for details of process(2). 
// 
//	Parameters for this process are defined in RRSelectParamData.
//	See RRSelectParamData.h for the detail. 
//
//-------------------------------------------------------------------=72

#ifndef _RR_SELECT_AUTO_TRIM_PROC_H
#define _RR_SELECT_SUTO_TRIM_PROC_H

#include "RRProcess.h"
#include "RRField.h"
#include "RRPixelStatisticsData.h"
#include "RR2DDoubleArrayData.h"
#include "RRSelectParamData.h"
#include "RRBSpline.h"

class RRSelectAutoTrimProc : public RRProcess
{
  private:

	double mTrimRatio;
	double mSaturationLevel;
	double mNoiseLevel;
	int mMaxSamplingNum;
	int mKernelSize;

  private:

	RRStatus mfSelectByTrimming(
			RRField< int >& select);
	RRStatus mfSelectBySampling(
			RRField< int >& select);
	RRStatus mfSelectByLimitting(
			const RRField< double >& mean,
			RRField< int >& select);
	RRStatus mfSelectByNoiseVarianceTest(
			const RRField< double >& variance,
			const RRField< double >& noise,
			RRField< int >& select);
	RRStatus mfSelectPixels(
			const RRField< double >& mean,
			const RRField< double >& variance,
			const RRField< double >& noise,
			RRField< int >& select);
	RRStatus mfMakeImArray(
			const RRField< double >& mean0,
			const RRField< double >& mean1,
			const RRField< int >& select0,
			const RRField< int >& select1,
			RRArray< RRArray< double > >& im);
	RRStatus mfIsImScattered(
			const RRArray< RRArray< double > >& im,
			bool& ret);
	RRStatus mfCalcKnots(
			const RRArray< double >& x,
			RRArray< double >& knot);
	RRStatus mfMakeSpline(
			const RRArray< double >& x,
			const RRArray< double >& y,
			RRBSpline& spl);

  public:

    RRSelectAutoTrimProc(
			const RRArray< RRData* >& in,	
									// in0 : RRPixelStatisticsData
									//	temporal average of im0
									// in1 : RRPixelStatisticsData
									//	temporal average of im1
									// in2 : RRPixelStatisticsData
									//	spatial average of im0
									// in3 : RRPixelStatisticsData
									//	spatial average of im1
									// in4 : RRSelectParamData
									//	parameters
			RRData *out);			// RR2DDoubleArrayData

	RRStatus doIt();
	// execute operation
};

#endif // _RR_SELECT_AUTO_TRIM_PROC_H

//-------------------------------------------------------------------=72
// End of RRSelectLowVariance.h
//-------------------------------------------------------------------=72
