//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRCombineProc.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Nov/21/1998:	Copied from eldRadianceMap.h
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// RRCombineProc combine input images into a high dynamic range image. 
//
// in[0]:			RRIaCurveData
//					a response curve and exposure ratios between images
// in[1]...in[n-2]: RRDoubleFieldData[n-2]
//					1 channel images
// in[n-1]:			RRCombineParamData
//					parameters
// out:				RRDoubleFieldData
//					1 channel combined image
//
//	A high dynamic rage image is obtained by the following steps.
//	
//	For each pixel,
//	(1) pixel values from input images are calibrated by the given 
//		response curve.
//	(2) Those calibrated pixel values are scaled by scale factors which 
//		are computed from given exposure ratios.
//	(3) all scaled pixel values are weighted by data reliability and
//		averaged. The averaged result is set to the output high dyamic
//		range image. 
//	
//	RRCombineProc process one channel image. For 3 channel image such 
//	as RGB image, RRCombineProc should be applied to every 3 channels
//	(See rrcombine.cpp).
//
//	Currently, there is no parameter to adjust performance of this 
//	process. So, RRCombineParamData is empty class for now. 
//
//-------------------------------------------------------------------=72

#ifndef _RR_COMBINE_PROC_H
#define _RR_COMBINE_PROC_H

#include "RRProcess.h"
#include "RRCombineParamData.h"
#include "RRDoubleFieldData.h"
#include "RRIaCurveData.h"

class RRCombineProc : public RRProcess
{
  private:

  private:

	double mfCalcWeight(const double im);
	double mfCalcBestIm();
	RRStatus mfCalcExposure(
			const RRArray< double >& ratio,
			RRArray< double >& exposure);

  public:

    RRCombineProc(
			RRArray< RRData* >& in,	
								// in[0]: RRIaCurveData
								// in[1]...in[n-2]: RRDoubleFieldData[n-2]
				                // in[n-1]: RRCombineParamData
			RRData *out);	    // RRDoubleFieldData

	RRStatus doIt();
	// execute operation
};

#endif // _RR_COMBINE_PROC_H

//-------------------------------------------------------------------=72
// End of RRCombineProc.h
//-------------------------------------------------------------------=72
