//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRColorBalanceProc.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//	Dec/16/1998:	Created
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// RRColorBalanceProc adjust color of I-image to color of M-images.
//
// in[0]:			RRFileListData
//					File list of image files (M-images).
// in[1]:			RRFileListData
//					File list of image (RRDoubleFieldData, I-image).
// in[2]:			RRCombineParamData
//					parameters
// out:				RRFileListData
//					File list of color balanced image. 
//
//	Color balancing is computed by the following steps.
//	
//	(1) Combine M-images into one image by selecting pixels. 
//		bestMLuminance paramter of RRCombineParamData is used to do 
//		pixel selection.
//	(2)	Select pixels which have neutral color in the combined M-image.
//		trimRatio and selectNeutralColorCriterion parameters of 
//		RRCombineParamData is used for the selecting.
//	(3) By using selected pixels, least square optimization is computed
//		to find scale factors of each channel (k=[kr,kg,kb]') so that
//		the following constraint is satisfied.
//			M/|M| = L/|L|, L = k'I
//			M: color of M-image
//			I: color of I-image
//			L: color of I-image after scaling
//	(4) I is scaled by k.
//
//	Parameters for RRColorBalanceProc are defined in RRCombineParamData.
//	See RRCombineParamData.h for detail. 
//
//-------------------------------------------------------------------=72

#ifndef _RR_COLOR_BALANCE_PROC_H
#define _RR_COLOR_BALANCE_PROC_H

#include "RRProcess.h"
#include "RRCombineParamData.h"
#include "RRDoubleFieldData.h"
#include "RRFileListData.h"
#include "RRPixelD.h"

class RRColorBalanceProc : public RRProcess
{
  private:  

	double mSaturationLevel;
	double mNoiseLevel;
	double mTrimRatio;
	double mBestMLuminance;
	double mSelectNeutralColorCriterion;

  private:

	RRStatus mfSetParam();
	RRStatus mfMakeMData(
			RRField< RRPixelD >& mimg);	
	RRStatus mfMakeIData(
			RRField< RRPixelD >& iimg);
	RRStatus mfCalcScales(
			const RRField< RRPixelD >& mimg,
			const RRField< RRPixelD >& iimg,
			RRArray< double >& k); //k[3]
	RRStatus mfScaleIData(
			const RRField< RRPixelD >& iimg,
			RRArray< double >& k, //k[3]
			RRField< RRPixelD >& cbal);

  public:    
  
  	RRColorBalanceProc(
			RRArray< RRData* >& in,
								// in[0]: RRFileListData (images)
								// in[1]: RRFileListData (RRDoubleFieldData)
				                // in[2]: RRCombineParamData
			RRData *out);	    // RRFileListData (a image)

	RRStatus doIt();
	// execute operation
};

#endif // _RR_COLOR_BALANCE_PROC_H

//-------------------------------------------------------------------=72
// End of RRColorBalanceProc.h
//-------------------------------------------------------------------=72