//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRCalibrateProc.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
// Date:                 Oct/31/1998
// Version:              1.0
//
// Modification History:
//  Oct/31/1998:	Copied from eldIaCurveFromN.h
//
// Bugs:
//
// Classes:
//
// Notes:
//
//-------------------------------------------------------------------=72
//
// This file defines RRCalibrateProc class.
// RRSelectProc estimates the transfer function of the camera system
//
//-------------------------------------------------------------------=72

#ifndef _RR_CALIBRATE_PROC_H
#define _RR_CALIBRATE_PROC_H

#include "RRProcess.h"
#include "RRCalibrateParamData.h"
#include "RR2DDoubleArrayData.h"
#include "RRIaCurveData.h"

class RRCalibrateProc : public RRProcess
{
  private:

  private:

	double mfCalcBase(
			const int idx,
			const double im0,
			const double im1,
			const double cR);
	RRStatus mfGaussJordan(
			const int dim,
			double *a,  // a[dim][dim]
			double *b,  // b[dim]
			double *x); // x[dim]
	RRStatus mfMakeMatrix(
			const RRArray< RRArray< RRArray< double > > >& im,
	        const int dim,
			const RRArray< double >& cR,
			double *a,	// a[dim][dim]
			double *b); // b[dim]
	RRStatus mfUpdateCoeff(
			const RRArray< RRArray< RRArray< double > > >& im,
			const int order,
			const RRArray< double >& cR,
			RRArray< double >& coeff);
	RRStatus mfCheckSimpleIncreasing(
			const RRArray< double >& coeff);
	RRStatus mfEvaluateError(
			const RRArray< RRArray< RRArray< double > > >& im,
			const RRArray< double >& cR,
			const RRArray< double >& coeff,
			double& err);
	RRStatus mfEstimateIaFunc(
			const int maxOrder,
			const RRArray< RRArray< RRArray< double > > >& im,
			const RRArray< double >& cR,
			RRPolynomial& ia,
			double& err);
	RRStatus mfRenewR(
			const RRArray< RRArray< RRArray< double > > >& im,
			const RRArray< double >& cR,
			const RRPolynomial& ia,
			RRArray< double >& nR);
	bool mfCheckConvergence(
			const double convergenceLevel,
			const RRPolynomial& pre,
			const RRPolynomial& cur);
	RRStatus mfOutput(
			const RRArray< double >& cR,
			const RRPolynomial& ia);

  private:
	// debug printing routines
	static int debugFileCount;
	void mfPrintDataNames(
			FILE *fp);
	void mfPrintData(
			FILE *fp,
			const int iter,
	        const RRPolynomial& ia,
			const double err,
			const RRArray< double >& cR,
			const RRArray< double >& nR);
  public:

    RRCalibrateProc(
			RRArray< RRData* >& in,	
								// in[0]...in[n-2]: RR2DDoubleArrayData[n]
				                // in[n-1]: RRCalibrateParamData
			RRData *out);	    // RRIaCurveData

	RRStatus doIt();
};

#endif // _RR_CALIBRATE_PROC_H

//-------------------------------------------------------------------=72
// End of RRCalibrateProc.h
//-------------------------------------------------------------------=72
