//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRPixelS.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//	Nov/22/1998:	Created
//
// Bugs:
//	We assume that ...
//		byte:	unsigned char = 1byte (0 to 255)
//		short:	unsigned short = 2byte (0 to 65,535)
//		double: double = 8byte (0. to 1.)
//
//-------------------------------------------------------------------=72
//
// RRPixelS class is a pixel data of 4 elements of 2byte.
//		elem[0] -> r
//		elem[1] -> g
//		elem[2] -> b
//		elem[3] -> a
//	this element order is important when you use get/setRawBits().
//	The range of value is from 0 to 65535. Smaller than 0 and grater 
//  than 65535 are clipped.
//
//-------------------------------------------------------------------=72

#ifndef _RR_PIXEL_S_H
#define _RR_PIXEL_S_H

#include "RRDef.h"

class RRPixelD; // double elements
class RRPixelB; // unsigned short elements

extern const unsigned short RRPS_MAX;
extern const unsigned short RRPS_MIN;

class RRPixelS
{
  private:

	unsigned short elem[4];

  private:

	static unsigned short convElem(unsigned short e);
	static unsigned short convElem(unsigned char e);
	static unsigned short convElem(double e);

 public:

	const unsigned short& getR()const;
	void setR(const unsigned short ir);
	const unsigned short& getG()const;
	void setG(const unsigned short ig);
	const unsigned short& getB()const;
	void setB(const unsigned short ib);
	const unsigned short& getA()const;
	void setA(const unsigned short ia);

	RRPixelS();
	RRPixelS(const unsigned short *p);
	// p must be an array of 4 elements.
	// p[4] -> elem[4]
	RRPixelS(
			const unsigned short r,
			const unsigned short g,
			const unsigned short b,
			const unsigned short a);
	RRPixelS(const RRPixelS& v);
	RRPixelS(const RRPixelD& v);
	RRPixelS(const RRPixelB& v);
	virtual ~RRPixelS();

	static int getByteSize(const int np);
	// return byte size of np channels.
	// ex. np=1 -> 2 byte.
	//     np=3 -> 6 byte.
	void getRawBits(const int np,void *bits)const;
	// bits must have np*2 byte length.
	// if np=1 -> r value is returned to bits.
	// if np=3 -> r,g and b values are returned to bits.
	// if np=4 -> r,g,b and a values are returned to bits.
	void setRawBits(const int np,const void *bits);
	// bits must have np*8 byte length.
	// if np=1 -> r value is replaced with bits data.
	// if np=3 -> r,g and b values are replaced with bits data.
	// if np=4 -> r,g,b and a values are replaced with bits data.

	const RRPixelS& operator=(const RRPixelS& v);
	friend bool operator==(const RRPixelS& v1,const RRPixelS& v2);
	friend bool operator!=(const RRPixelS& v1,const RRPixelS& v2);
	friend RRPixelS operator+(const RRPixelS& v1,const RRPixelS& v2);
	friend RRPixelS operator-(const RRPixelS& v1,const RRPixelS& v2);
	friend RRPixelS operator*(const RRPixelS& v,const double& r);
	friend RRPixelS operator*(const double& r,const RRPixelS& v);
};
    
#endif // _RR_PIXEL_S_H

//-------------------------------------------------------------------=72
// End of RRPixelS.h
//-------------------------------------------------------------------=72
