//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRPixelD.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.1
//
// Modification History:
//  Oct/27/1998:	Copied from eldPixelD.h
//	Nov/22/1998:	Renewed image and pixel classes
//
// Bugs:
//	We assume that ...
//		byte:	unsigned char = 1byte (0 to 255)
//		short:	unsigned short = 2byte (0 to 65,535)
//		double: double = 8byte (0. to 1.)
//
//-------------------------------------------------------------------=72
//
//	RRPixelD class is a pixel data of 4 elements of double.
//		elem[0] -> r
//		elem[1] -> g
//		elem[2] -> b
//		elem[3] -> a
//	this element order is important when you use get/setRawBits().
//	The range of value is from 0. to 1. Smaller than 0. and grater than
//	1. are clipped.
//
//-------------------------------------------------------------------=72

#ifndef _RR_PIXEL_D_H
#define _RR_PIXEL_D_H

#include "RRDef.h"

class RRPixelB; // byte elements
class RRPixelS; // unsigned short elements

extern const double RRPD_MAX; // 1.
extern const double RRPD_MIN; // 0.

class RRPixelD
{
  private:

	double elem[4];
	
  private:

	static double convElem(double e);
	static double convElem(unsigned char e);
	static double convElem(unsigned short e);

  public:
  
	const double& getR()const;
	void setR(const double ir);
	const double& getG()const;
	void setG(const double ig);
	const double& getB()const;
	void setB(const double ib);
	const double& getA()const;
	void setA(const double ia);

	RRPixelD();
	RRPixelD(const double *p);
	// p must be an array of 4 elements.
	// p[4] -> elem[4]
	RRPixelD(const double r,const double g,const double b,const double a);
	RRPixelD(const RRPixelB& v);
	RRPixelD(const RRPixelS& v);
	RRPixelD(const RRPixelD& v);
	virtual ~RRPixelD();
	
	static int getByteSize(const int np);
	// return byte size of np channels.
	// ex. np=1 -> 8 byte.
	//     np=3 -> 24 byte.
	void getRawBits(const int np,void *bits)const;
	// bits must have np*8 byte length.
	// if np=1 -> r value is returned to bits.
	// if np=3 -> r,g and b values are returned to bits.
	// if np=4 -> r,g,b and a values are returned to bits.
	void setRawBits(const int np,const void *bits);
	// bits must have np*8 byte length.
	// if np=1 -> r value is replaced with bits data.
	// if np=3 -> r,g and b values are replaced with bits data.
	// if np=4 -> r,g,b and a values are replaced with bits data.

	const RRPixelD& operator=(const RRPixelD& v);
	friend bool operator==(const RRPixelD& v1,const RRPixelD& v2);
	friend bool operator!=(const RRPixelD& v1,const RRPixelD& v2);
	friend RRPixelD operator+(const RRPixelD& v1,const RRPixelD& v2);
	friend RRPixelD operator-(const RRPixelD& v1,const RRPixelD& v2);
	friend RRPixelD operator*(const RRPixelD& v,const double& r);
	friend RRPixelD operator*(const double& r,const RRPixelD& v);
};
    
#endif // _RR_PIXEL_D_H

//-------------------------------------------------------------------=72
// End of RRPixelD.h
//-------------------------------------------------------------------=72
