//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRPixelB.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.1
//
// Modification History:
//  Oct/27/1998:	Copied from eldPixelB.h
//	Nov/22/1998:	Renewed image and pixel classes
//
// Bugs:
//	We assume that ...
//		byte:	unsigned char = 1byte (0 to 255)
//		short:	unsigned short = 2byte (0 to 65,535)
//		double: double = 8byte (0. to 1.)
//
//-------------------------------------------------------------------=72
//
//	RRPixelB is a pixel data of 4 (r,g,b and a) elements of byte.
//		elem[0] -> r
//		elem[1] -> g
//		elem[2] -> b
//		elem[3] -> a
//	this element order is important when you use get/setRawBits().
//	The range of value is from 0 to 255. Smaller than 0 and grater than
//	255 are clipped.
//	
//-------------------------------------------------------------------=72

#ifndef _RR_PIXEL_B_H
#define _RR_PIXEL_B_H

#include "RRDef.h"

class RRPixelD; // double elements
class RRPixelS; // unsigned short elements

extern const unsigned char RRPB_MAX; // 255
extern const unsigned char RRPB_MIN; // 0

class RRPixelB
{
  private:

	unsigned char elem[4];

  private:

	static unsigned char convElem(unsigned char e);
	static unsigned char convElem(unsigned short e);
	static unsigned char convElem(double e);
	
 public:

	const unsigned char& getR()const;
	void setR(const unsigned char ir);
	const unsigned char& getG()const;
	void setG(const unsigned char ig);
	const unsigned char& getB()const;
	void setB(const unsigned char ib);
	const unsigned char& getA()const;
	void setA(const unsigned char ia);
	// get/set an element value.

	RRPixelB();
	RRPixelB(const int p); 
	// assuming int = 4byte
	RRPixelB(const unsigned char *p);
	// p must be an array of 4 elements.
	// p[4] -> elem[4]
	RRPixelB(
			const unsigned char r,
			const unsigned char g,
			const unsigned char b,
			const unsigned char a);
	RRPixelB(const RRPixelB& v);
	RRPixelB(const RRPixelD& v);
	RRPixelB(const RRPixelS& v);
	virtual ~RRPixelB();

	static int getByteSize(const int np);
	// return byte size of np channels.
	// ex. np=1 -> 1 byte.
	//     np=3 -> 3 byte.
	void getRawBits(const int np,void *bits)const;
	// bits must have np*1 byte length.
	// if np=1 -> r value is returned to bits.
	// if np=3 -> r,g and b values are returned to bits.
	// if np=4 -> r,g,b and a values are returned to bits.
	void setRawBits(const int np,const void *bits);
	// bits must have np*1 byte length.
	// if np=1 -> r value is replaced with bits data.
	// if np=3 -> r,g and b values are replaced with bits data.
	// if np=4 -> r,g,b and a values are replaced with bits data.

	const RRPixelB& operator=(const RRPixelB& v);
	friend bool operator==(const RRPixelB& v1,const RRPixelB& v2);
	friend bool operator!=(const RRPixelB& v1,const RRPixelB& v2);

	friend RRPixelB operator+(const RRPixelB& v1,const RRPixelB& v2);
	friend RRPixelB operator-(const RRPixelB& v1,const RRPixelB& v2);
	friend RRPixelB operator*(const RRPixelB& v,const double& r);
	friend RRPixelB operator*(const double& r,const RRPixelB& v);
};
    
#endif // _RR_PIXEL_B_H

//-------------------------------------------------------------------=72
// End of RRPixelB.h
//-------------------------------------------------------------------=72
