//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRPPMImage.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.1
//
// Modification History:
//  Oct/27/1998:	Copied from eldPPMImage.h
//	Nov/22/1998:	Renewed image and pixel classes
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RRPPMImage class is a RRImage class which has I/O interface to PPM
//	file (Portable pixmap file). A certain file name must be specified
//	when a instance is created.
//
//	RRROPPMImage is a read only RRPPMImage.
//	RRWOPPMImage is a write only RRPPMImage.
//
//-------------------------------------------------------------------=72

#ifndef _RR_PPM_IMAGE_H
#define _RR_PPM_IMAGE_H

#include "RRDef.h"
#include "RRImage.h"
#include "RRPixelB.h"

class RRPPMImage : public RRImage< RRPixelB >
{
  private:

	char fileName[256];

  private:

  public:

	RRPPMImage(const char *filename);
	RRPPMImage(const char *filename, const RRImage< RRPixelB>& v);
	virtual ~RRPPMImage();

	RRStatus save();
	RRStatus load();

	const RRPPMImage& operator=(const RRPPMImage& v);
	friend bool operator==(const RRPPMImage& v1,const RRPPMImage& v2);
	friend bool operator!=(const RRPPMImage& v1,const RRPPMImage& v2);
};


class RRROPPMImage : public RRPPMImage
{
  protected:

	RRStatus save();

	const RRPPMImage& operator=(const RRPPMImage& v);
	const RRImage< RRPixelB >& operator=(const RRImage< RRPixelB >& v);

  public:

    RRROPPMImage(const char *filename):RRPPMImage(filename)
	{load();}

    virtual ~RRROPPMImage(){}
};

class RRWOPPMImage : public RRPPMImage
{
  protected:

	RRStatus load();

  public:

    RRWOPPMImage(const char *filename):RRPPMImage(filename)
	{}

    virtual ~RRWOPPMImage(){save();}

	const RRPPMImage& operator=(const RRPPMImage& v)
	{return RRPPMImage::operator=(v);}
	
	const RRImage< RRPixelB >& operator=(const RRImage< RRPixelB >& v)
	{return RRImage< RRPixelB >::operator=(v);}
};


    
#endif // _RR_PPM_IMAGE_H

//-------------------------------------------------------------------=72
// End of RRPPMImage.h
//-------------------------------------------------------------------=72
