//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRPPMImage.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.1
//
// Modification History:
//  Oct/27/1998:	Copied from eldPPMImage.cpp
//	Nov/22/1998:	Renewed image and pixel classes
//	Jun/15/1999:	Bug fix in load(): reading max value
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "RRPPMImage.h"

#include <stdio.h>
#include <string.h>

RRPPMImage::RRPPMImage(const char *filename)
:RRImage< RRPixelB >()
{
	strcpy(fileName,filename);
}

RRPPMImage::RRPPMImage(const char *filename, const RRImage< RRPixelB >& v)
:RRImage< RRPixelB >(v)
{
	strcpy(fileName,filename);
}

RRPPMImage::~RRPPMImage(){}

RRStatus RRPPMImage::save()
{
	const int maxval = 255;
	const int numsavechannels = 3; // RGB only (no A chan)

	FILE *fp = fopen(fileName,"wb");
	if(fp==NULL)
		return RR_ERROR;

	int x,y;
	getSize(x,y);

	fprintf(fp,"P6\n");
	fprintf(fp,"# Creator : RR Library\n");
	fprintf(fp,"%d %d\n",x,y);
	fprintf(fp,"%d\n",maxval);

	int rowsize=x*numsavechannels;
	int size=rowsize*y;
	unsigned char *bits = new unsigned char[size];
	unsigned char *row = new unsigned char[rowsize];

	getRawBits(numsavechannels,bits);
	for(int i=0;i<y;i++)
	{
		int offset=rowsize*(y-i-1);
		memcpy(row,bits+offset,rowsize*sizeof(unsigned char));
		int nr=fwrite(row,sizeof(unsigned char),rowsize,fp);
		assert(nr==rowsize);
	}

	fclose(fp);
	delete[] bits;
	delete[] row;
	return RR_SUCCESS;
}

RRStatus RRPPMImage::load()
{
	const int maxval = 255;
	const int numsavechannels = 3; // RGB only (no A chan)

	FILE *fp = fopen(fileName,"rb");
	if(fp==NULL)
		return RR_ERROR;
	
	char buf[256];

	char magic[3];
	fgets(buf,256,fp);
	sscanf(buf,"%s\n",magic);
	if(strcmp(magic,"P6")!=0)
		return RR_ERROR;

	buf[0]='#';
	while(buf[0]=='#')
		fgets(buf,256,fp);

	int x,y;
	sscanf(buf,"%d %d\n",&x,&y);
	setSize(x,y);

	int max;
	fgets(buf,256,fp);
	sscanf(buf,"%d\n",&max);
	if(max!=maxval)
		return RR_ERROR;

	int rowsize=x*numsavechannels;
	int size=rowsize*y;
	unsigned char *bits = new unsigned char[size];
	unsigned char *row = new unsigned char[rowsize];

	for(int i=0;i<y;i++)
	{
		int nr=fread(row,sizeof(unsigned char),rowsize,fp);
		assert(nr==rowsize);
		int offset=rowsize*(y-i-1);
		memcpy(bits+offset,row,rowsize*sizeof(unsigned char));
	}
	setRawBits(numsavechannels,bits);

	fclose(fp);
	delete[] bits;
	delete[] row;
	return RR_SUCCESS;
}

const RRPPMImage& RRPPMImage::operator=(const RRPPMImage& v)
{
	RRImage< RRPixelB >::operator=(v);
	//strcpy(fileName,v.fileName);
	return *this;
}

bool operator==(const RRPPMImage& v1,const RRPPMImage& v2)
{
	return (operator==((const RRImage< RRPixelB >&)v1,(const RRImage< RRPixelB >&)v2) &&
			!strcmp(v1.fileName,v2.fileName))?true:false;
}

bool operator!=(const RRPPMImage& v1,const RRPPMImage& v2)
{
	return (operator!=((const RRImage< RRPixelB >&)v1,(const RRImage< RRPixelB >&)v2) ||
			strcmp(v1.fileName,v2.fileName))?true:false;
}

//-------------------------------------------------------------------=72
// End of RRPPMImage.cpp
//-------------------------------------------------------------------=72
