//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRPPM16Image.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Nov/30/1998:	Copied from eldPPM2Image.h
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RRPPM16Image class is a RRImage class which has I/O interface to 
//	PPM16 file.
//
//	PPM16 format is a 16bit extention from PPM format. 2byte is used for 
//	each intensity value. So, 6byte is used for 1 pixel. PPM16 contains 
//	data as binary (ascii is not suppoerted) and with interleaved order. 
//	As PPM does, PPM16 has a header which includes a magic number (=P6, 
//	same to PPM), x size, y size, and maximum value (=65535).     
//
//	A certain file name must be specified when a instance is created.
//
//	RRROPPM16Image is a read only RRPPM16Image.
//	RRWOPPM16Image is a write only RRPPM16Image.
//
//-------------------------------------------------------------------=72

#ifndef _RR_PPM16_IMAGE_H
#define _RR_PPM16_IMAGE_H

#include "RRDef.h"
#include "RRImage.h"
#include "RRPixelS.h"

class RRPPM16Image : public RRImage< RRPixelS >
{
  protected:

	char fileName[256];

  private:

  public:

	RRPPM16Image(const char *filename);
	RRPPM16Image(const char *filename, const RRImage< RRPixelS >& v);
	virtual ~RRPPM16Image();

	RRStatus save();
	RRStatus load();

	const RRPPM16Image& operator=(const RRPPM16Image& v);
	friend bool operator==(const RRPPM16Image& v1,const RRPPM16Image& v2);
	friend bool operator!=(const RRPPM16Image& v1,const RRPPM16Image& v2);
};


class RRROPPM16Image : public RRPPM16Image
{
  protected:

	RRStatus save();

	const RRPPM16Image& operator=(const RRPPM16Image& v);
	const RRImage< RRPixelS >& operator=(const RRImage< RRPixelS >& v);

  public:

    RRROPPM16Image(const char *filename):RRPPM16Image(filename)
	{load();}

    virtual ~RRROPPM16Image(){}
};

class RRWOPPM16Image : public RRPPM16Image
{
  protected:

	RRStatus load();

  public:

    RRWOPPM16Image(const char *filename):RRPPM16Image(filename)
	{}

    virtual ~RRWOPPM16Image(){save();}

	const RRPPM16Image& operator=(const RRPPM16Image& v)
	{return RRPPM16Image::operator=(v);}
	
	const RRImage< RRPixelS >& operator=(const RRImage< RRPixelS >& v)
	{return RRImage< RRPixelS >::operator=(v);}
};


    
#endif // _RR_PPM16_IMAGE_H

//-------------------------------------------------------------------=72
// End of RRPPM16Image.h
//-------------------------------------------------------------------=72
