//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRPPM16Image.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Nov/30/1998:	Copied from RRPPMImage.cpp
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "RRPPM16Image.h"

#include <stdio.h>
#include <string.h>

RRPPM16Image::RRPPM16Image(const char *filename)
:RRImage< RRPixelS >()
{
	strcpy(fileName,filename);
}

RRPPM16Image::RRPPM16Image(const char *filename, const RRImage< RRPixelS >& v)
:RRImage< RRPixelS >(v)
{
	strcpy(fileName,filename);
}

RRPPM16Image::~RRPPM16Image(){}

RRStatus RRPPM16Image::save()
{
	const int numsavechannels = 3; // RGB only (no A chan)

	FILE *fp = fopen(fileName,"wb");
	if(fp==NULL)
		return RR_ERROR;

	int x,y;
	getSize(x,y);

	fprintf(fp,"P6\n");
	fprintf(fp,"# Creator : RR Library\n");
	fprintf(fp,"%d %d\n",x,y);
	fprintf(fp,"%d\n",RRPS_MAX); 

	int rowsize=x*numsavechannels;
	int size=rowsize*y;
	unsigned short *bits = new unsigned short[size];
	unsigned short *row = new unsigned short[rowsize];

	getRawBits(numsavechannels,bits);
	for(int i=0;i<y;i++)
	{
		int offset=rowsize*(y-i-1);
		memcpy(row,bits+offset,rowsize*sizeof(unsigned short));
		int nr=fwrite(row,sizeof(unsigned short),rowsize,fp);
		assert(nr==rowsize);
	}

	fclose(fp);
	delete[] bits;
	delete[] row;
	return RR_SUCCESS;
}

RRStatus RRPPM16Image::load()
{
	const int numsavechannels = 3; // RGB only (no A chan)

	FILE *fp = fopen(fileName,"rb");
	if(fp==NULL)
		return RR_ERROR;
	
	char buf[256];

	char magic[3];
	fgets(buf,256,fp);
	sscanf(buf,"%s\n",magic);
	if(strcmp(magic,"P6")!=0)
		return RR_ERROR;

	buf[0]='#';
	while(buf[0]=='#')
		fgets(buf,256,fp);

	int x,y;
	sscanf(buf,"%d %d\n",&x,&y);
	setSize(x,y);

	int max;
	fgets(buf,256,fp);
	sscanf(buf,"%d\n",&max);
	if(max!=RRPS_MAX)
		return RR_ERROR;

	int rowsize=x*numsavechannels;
	int size=rowsize*y;
	unsigned short *bits = new unsigned short[size];
	unsigned short *row = new unsigned short[rowsize];

	for(int i=0;i<y;i++)
	{
		int nr=fread(row,sizeof(unsigned short),rowsize,fp);
		assert(nr==rowsize);
		int offset=rowsize*(y-i-1);
		memcpy(bits+offset,row,rowsize*sizeof(unsigned short));
	}
	setRawBits(numsavechannels,bits);

	fclose(fp);
	delete[] bits;
	delete[] row;
	return RR_SUCCESS;
}

const RRPPM16Image& RRPPM16Image::operator=(const RRPPM16Image& v)
{
	RRImage< RRPixelS >::operator=(v);
	//strcpy(fileName,v.fileName);
	return *this;
}

bool operator==(const RRPPM16Image& v1,const RRPPM16Image& v2)
{
	return (operator==((const RRImage< RRPixelS >&)v1,(const RRImage< RRPixelS >&)v2) &&
			!strcmp(v1.fileName,v2.fileName))?true:false;
}

bool operator!=(const RRPPM16Image& v1,const RRPPM16Image& v2)
{
	return (operator!=((const RRImage< RRPixelS >&)v1,(const RRImage< RRPixelS >&)v2) ||
			strcmp(v1.fileName,v2.fileName))?true:false;
}

//-------------------------------------------------------------------=72
// End of RRPPM16Image.cpp
//-------------------------------------------------------------------=72
