//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRImage.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.1
//
// Modification History:
//  Oct/27/1998:	Copied from eldImage.h
//	Nov/22/1998:	Renewed image and pixel classes
//
// Bugs:
//	We assume that ...
//		byte:	unsigned char = 1byte (0 to 255)
//		short:	unsigned short = 2byte (0 to 65,535)
//		double: double = 8byte (0. to 1.)
//
//-------------------------------------------------------------------=72
//
//	RRImage class is a RRField of pixels.
//	Type T specifies the type of pixel. T must be a RRPixel* class, 
//	otherwise RRImage does not work correctly.
//	The origin of RRImage is bottom-left. And data order is ...
//		(0,0),(1,0),(2,0),...,(xs-1,0),(0,1),...,(xs-1,ys-1)	
//	The last pixel is top-right. Understanding this order is important 
//	when you use get/setRawBits().
// 
//-------------------------------------------------------------------=72

#ifndef _RR_IMAGE_H
#define _RR_IMAGE_H

#include "RRDef.h"
#include "RRField.h"

template < class T >
class RRImage : public RRField< T >
{
  private:

  public:

 	static int getPixelByteSize(const int np);

 	void getRawBits(const int np,void *bits)const;
	void setRawBits(const int np,const void *bits);
	// Get/set raw bit data of whole image.
	// np specifies # of channel to get/set. 
	// Set np=4 for all channels, np=3 for rgb channels,
	// np=1 for only r channel. 
	// bits is used as the address in which raw bit data is stored.
	// bits must have np*sizeof(channel)*(image size) length.

  public:
  
	RRImage();
	RRImage(const int xs,const int ys);
	RRImage(const int xs,const int ys,const T& col);
	// filled with col. 
	RRImage(const RRImage<T>& v);
	virtual ~RRImage();

	const RRImage<T>& operator=(const RRImage<T>& v);
	friend bool operator==(const RRImage<T>& v1,const RRImage<T>& v2);
	friend bool operator!=(const RRImage<T>& v1,const RRImage<T>& v2);
};
    
//-------------------------------------------------------------------=72

template <class T>
int RRImage<T>::getPixelByteSize(const int np)
{
	return T::getByteSize(np);
}

template <class T>
void RRImage<T>::getRawBits(const int np,void *bits)const
{
	unsigned char *tmp=(unsigned char *)bits;
	const int pixelSize=T::getByteSize(np);
	
	int xs,ys;
	getSize(xs,ys);

	for(int y=0;y<ys;y++)
		for(int x=0;x<xs;x++)
		{
			getElem(x,y).getRawBits(np,tmp);
			tmp+=pixelSize;
		}
}

template <class T>
void RRImage<T>::setRawBits(const int np,const void *bits)
{
	const unsigned char *tmp=(const unsigned char *)bits;
	const int pixelSize=T::getByteSize(np);

	int xs,ys;
	getSize(xs,ys);

	for(int y=0;y<ys;y++)
		for(int x=0;x<xs;x++)
		{
			T pxl;
			pxl.setRawBits(np,tmp);
			setElem(x,y,pxl);
			tmp+=pixelSize;
		}
}

template <class T>
RRImage<T>::RRImage()
:RRField<T>()
{}

template <class T>
RRImage<T>::RRImage(const int xs,const int ys)
:RRField<T>(xs,ys)
{}

template <class T>
RRImage<T>::RRImage(const int xs,const int ys,const T& col)
:RRField<T>(xs,ys,col)
{}

template <class T>
RRImage<T>::RRImage(const RRImage<T>& v)
:RRField<T>(v)
{}

template <class T>
RRImage<T>::~RRImage()
{}

template <class T>
const RRImage<T>& RRImage<T>::operator=(const RRImage<T>& v)
{
	RRField<T>::operator=(v);
    return *this;
}

template <class T>
bool operator==(const RRImage<T>& v1,const RRImage<T>& v2)
{
	return operator==((const RRField< T >&)v1,(const RRField< T >&)v2);
}

template <class T>
bool operator!=(const RRImage<T>& v1,const RRImage<T>& v2)
{
	return operator!=((const RRField< T >&)v1,(const RRField< T >&)v2);
}

#endif // _RR_IMAGE_H

//-------------------------------------------------------------------=72
// End of RRImage.h
//-------------------------------------------------------------------=72
