//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRBMPImage.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.1
//
// Modification History:
//  Oct/27/1998:	Copied from eldBMPImage.h
//	Nov/22/1998:	Renewed image and pixel classes
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RRBMPImage class is a RRImage class which has I/O interface to BMP
//	file (Windows bit map file). A certain file name must be specified
//	when a instance is created.
//
//	RRROBMPImage is a read only RRBMPImage.
//	RRWOBMPImage is a write only RRBMPImage.
//
//-------------------------------------------------------------------=72

#ifndef _RR_BMP_IMAGE_H
#define _RR_BMP_IMAGE_H

#include "RRDef.h"
#include "RRImage.h"
#include "RRPixelB.h"

#include <windows.h>
#include <wingdi.h>

class RRBMPImage : public RRImage< RRPixelB >
{

  private:

	char fileName[256];

  private:

	unsigned char *loadDIBitmap(const char	*filename, 
                                BITMAPINFO	**info);
	
	int saveDIBitmap(const char *filename,
	                 BITMAPINFO *info,	
                     void       *bits);	

	void convertRGB(BITMAPINFO *info,	
					unsigned char *bits,	
					unsigned char *newbits,
					int BMPtoRGB);
					
  public:

	RRBMPImage(const char *filename);
	RRBMPImage(const char *filename, const RRImage< RRPixelB >& v);
	virtual ~RRBMPImage();

	RRStatus save();
	RRStatus load();

	const RRBMPImage& operator=(const RRBMPImage& v);
	friend bool operator==(const RRBMPImage& v1,const RRBMPImage& v2);
	friend bool operator!=(const RRBMPImage& v1,const RRBMPImage& v2);
};



class RRROBMPImage : public RRBMPImage
{
  protected:

	RRStatus save();

	const RRBMPImage& operator=(const RRBMPImage& v);

	const RRImage< RRPixelB >& operator=(const RRImage< RRPixelB >& v);

  public:

    RRROBMPImage(const char *filename):RRBMPImage(filename)
	{load();}

    virtual ~RRROBMPImage(){}

};

class RRWOBMPImage : public RRBMPImage
{
  protected:

	RRStatus load();

  public:

    RRWOBMPImage(const char *filename):RRBMPImage(filename)
	{}

    virtual ~RRWOBMPImage(){save();}

	const RRBMPImage& operator=(const RRBMPImage& v)
	{return RRBMPImage::operator=(v);}

	const RRImage< RRPixelB >& operator=(const RRImage< RRPixelB >& v)
	{return RRImage< RRPixelB >::operator=(v);}
};

#endif // _RR_BMP_IMAGE_H

//-------------------------------------------------------------------=72
// End of RRBMPImage.h
//-------------------------------------------------------------------=72
