//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRBMPImage.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.2
//
// Modification History:
//  Oct/27/1998:	Copied from eldBMPImage.h
//	Nov/22/1998:	Renewed image and pixel classes
//	Apr/04/1999:	Including windows.h and wingdi.h is removed
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RRBMPImage class is a RRImage class which has I/O interface to BMP
//	file (Windows bit map file). A certain file name must be specified
//	when a instance is created.
//
//	RRROBMPImage is a read only RRBMPImage.
//	RRWOBMPImage is a write only RRBMPImage.
//
//-------------------------------------------------------------------=72

#ifndef _RR_BMP_IMAGE_H
#define _RR_BMP_IMAGE_H

#include "RRDef.h"
#include "RRImage.h"
#include "RRPixelB.h"

#include <stdio.h>

struct RRWinBitmapFileHeader
{ // BITMAPFILEHEADER
	static int SIZE_OF;

	unsigned short bfType; //unsigned short
    unsigned long bfSize;         
	unsigned short bfReserved1; //unsigned short
	unsigned short bfReserved2; //unsigned short        
	unsigned long bfOffBits; 

	RRStatus load(FILE *fp)
	{
		fread(&bfType,1,sizeof(unsigned short),fp);
		fread(&bfSize,1,sizeof(unsigned long),fp);
		fread(&bfReserved1,1,sizeof(unsigned short),fp);
		fread(&bfReserved2,1,sizeof(unsigned short),fp);
		fread(&bfOffBits,1,sizeof(unsigned long),fp);
		return RR_SUCCESS;
	}

	RRStatus save(FILE *fp)const
	{
		fwrite(&bfType,1,sizeof(unsigned short),fp);
		fwrite(&bfSize,1,sizeof(unsigned long),fp);
		fwrite(&bfReserved1,1,sizeof(unsigned short),fp);
		fwrite(&bfReserved2,1,sizeof(unsigned short),fp);
		fwrite(&bfOffBits,1,sizeof(unsigned long),fp);
		return RR_SUCCESS;
	}
};

struct RRWinBitmapInfoHeader
{ // BITMAPINFOHEADER    
	unsigned long  biSize; 
	unsigned long   biWidth;
	unsigned long   biHeight;    
	unsigned short   biPlanes;    
	unsigned short   biBitCount; 
	unsigned long  biCompression;    
	unsigned long biSizeImage;    
	unsigned long   biXPelsPerMeter; 
	unsigned long   biYPelsPerMeter;    
	unsigned long  biClrUsed;    
	unsigned long  biClrImportant; 

	RRStatus load(FILE *fp)
	{
		fread(&biSize,1,sizeof(unsigned long),fp);
		fread(&biWidth,1,sizeof(unsigned long),fp);
		fread(&biHeight,1,sizeof(unsigned long),fp);
		fread(&biPlanes,1,sizeof(unsigned short),fp);
		fread(&biBitCount,1,sizeof(unsigned short),fp);
		fread(&biCompression,1,sizeof(unsigned long),fp);
		fread(&biSizeImage,1,sizeof(unsigned long),fp);
		fread(&biXPelsPerMeter,1,sizeof(unsigned long),fp);
		fread(&biYPelsPerMeter,1,sizeof(unsigned long),fp);
		fread(&biClrUsed,1,sizeof(unsigned long),fp);
		fread(&biClrImportant,1,sizeof(unsigned long),fp);
		return RR_SUCCESS;
	}

	RRStatus save(FILE *fp)const
	{
		fwrite(&biSize,1,sizeof(unsigned long),fp);
		fwrite(&biWidth,1,sizeof(unsigned long),fp);
		fwrite(&biHeight,1,sizeof(unsigned long),fp);
		fwrite(&biPlanes,1,sizeof(unsigned short),fp);
		fwrite(&biBitCount,1,sizeof(unsigned short),fp);
		fwrite(&biCompression,1,sizeof(unsigned long),fp);
		fwrite(&biSizeImage,1,sizeof(unsigned long),fp);
		fwrite(&biXPelsPerMeter,1,sizeof(unsigned long),fp);
		fwrite(&biYPelsPerMeter,1,sizeof(unsigned long),fp);
		fwrite(&biClrUsed,1,sizeof(unsigned long),fp);
		fwrite(&biClrImportant,1,sizeof(unsigned long),fp);
		return RR_SUCCESS;
	}
}; 

class RRBMPImage : public RRImage< RRPixelB >
{

  private:

	char mFileName[256];

  private:

	unsigned char *mfLoadBitmap(
			FILE *fp, 
            RRWinBitmapInfoHeader& info);
	RRStatus mfTransferBitmap(
			const RRWinBitmapInfoHeader& info,	
			unsigned char *bits,	
			unsigned char *newbits,
			bool BMPtoRGB)const;
	RRStatus mfSaveBitmap(
			FILE *fp,
	        const RRWinBitmapInfoHeader& info,	
            const void *bits)const;
					
  public:

	RRBMPImage(const char *filename);
	RRBMPImage(const char *filename, const RRImage< RRPixelB >& v);
	virtual ~RRBMPImage();

	RRStatus save()const;
	RRStatus load();

	const RRBMPImage& operator=(const RRBMPImage& v);
	friend bool operator==(const RRBMPImage& v1,const RRBMPImage& v2);
	friend bool operator!=(const RRBMPImage& v1,const RRBMPImage& v2);
};



class RRROBMPImage : public RRBMPImage
{
  protected:

	RRStatus save();

	const RRBMPImage& operator=(const RRBMPImage& v);

	const RRImage< RRPixelB >& operator=(const RRImage< RRPixelB >& v);

  public:

    RRROBMPImage(const char *filename):RRBMPImage(filename)
	{load();}

    virtual ~RRROBMPImage(){}

};

class RRWOBMPImage : public RRBMPImage
{
  protected:

	RRStatus load();

  public:

    RRWOBMPImage(const char *filename):RRBMPImage(filename)
	{}

    virtual ~RRWOBMPImage(){save();}

	const RRBMPImage& operator=(const RRBMPImage& v)
	{return RRBMPImage::operator=(v);}

	const RRImage< RRPixelB >& operator=(const RRImage< RRPixelB >& v)
	{return RRImage< RRPixelB >::operator=(v);}
};

#endif // _RR_BMP_IMAGE_H

//-------------------------------------------------------------------=72
// End of RRBMPImage.h
//-------------------------------------------------------------------=72
