//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRRootHandler.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// RRRootHandler.h defines RRRootHandler class.
// The RRRootHandler class is the top of event handling tree in a 
// application. A RRRootHandler makes RREvent to transfer to its 
// children.
//
//-------------------------------------------------------------------=72

#ifndef _RR_ROOT_HANDLER_H
#define _RR_ROOT_HANDLER_H

#include "RRDef.h"
#include "RREventHandler.h"

class RRRootHandler : public RREventHandler
{
  protected:
  
  	RREvent *mEventCache;
  
  protected:
  
//	virtual bool isHit(const RREvent& e)const{return true;}
	// RRRootHandler allways returns true.
	  
  	virtual RRStatus mfHandleEvent(
				const RREvent& e)
  	{mfSetLocking(NULL);return RR_UNLOCKED;}
  	
  	virtual RRStatus mfMakeEvent(const void *e) = 0;
  	// Makes the content of the eventCache.
  	// Returns RRSUCCESS if it's done without error, or return RRERROR if not.
  	
  public:
  
  	virtual RRStatus handleEvent(const RREvent& e){return RR_ERROR;}

  	virtual RRStatus handleEvent(const void *e);
  	// THIS IS OVERRIDING, DO NOT USE handleEvent(const RREvent& e).
  	// Makes an RREvent and from the given event and process it. 
	// Returns RRERROR if incorrect event is input.
	  	  
  	RRRootHandler();
  	// RRRootHandler does not need a parent.
  	 
  	RRRootHandler(const RRRootHandler& x);
  	// A copy constructor.
  	
  	virtual ~RRRootHandler();
  	
  	const RRRootHandler& operator=(const RRRootHandler& x);
};
    
#endif // _RR_ROOT_HANDLER_H

//-------------------------------------------------------------------=72
// End of RRRootHandler.h
//-------------------------------------------------------------------=72
