//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRRootHandler.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#define _RR_ROOT_HANDLER_C

#include "RRRootHandler.h"

RRStatus RRRootHandler::handleEvent(const void *e)
{
	mEventCache = new RREvent;
	if(mfMakeEvent(e)==RR_ERROR)
		return RR_ERROR;
	
	RRStatus status=RREventHandler::handleEvent(*mEventCache); 
	delete mEventCache;
	mEventCache=NULL;
	return status;
}

RRRootHandler::RRRootHandler()
:RREventHandler(NULL),
 mEventCache(NULL)
 {}

RRRootHandler::RRRootHandler(const RRRootHandler& x)
:RREventHandler(x),
 mEventCache(NULL)
{
 	if(x.mEventCache!=NULL)
	{
		mEventCache = new RREvent;	
		*mEventCache= *(x.mEventCache);
	}
}

RRRootHandler::~RRRootHandler(){delete mEventCache;}
  	
const RRRootHandler& RRRootHandler::operator=(
			const RRRootHandler& x)
{
	RREventHandler::operator=(x);
	delete mEventCache;
	if(x.mEventCache!=NULL)
	{
		mEventCache = new RREvent;	
		*mEventCache= *(x.mEventCache);
	}
	else
		mEventCache=NULL;

	return *this;
}

//-------------------------------------------------------------------=72
// End of RRRootHandler.h
//-------------------------------------------------------------------=72
