//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRMobileRectHandler.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// RRMobileRectHandler class is a RREventHandler class which is 
// specializeda for handling mobile rectangle in a view window. 
//
//-------------------------------------------------------------------=72

#ifndef _RR_MOBILE_RECT_HANDLER_H
#define _RR_MOBILE_RECT_HANDLER_H

#include "RREventHandler.h"

class RRMobileRectHandler : public RREventHandler
{
  private:
  
	RRGrid2 mBL; // BottomLeft corner
	RRGrid2 mTR; // TopRight corner

  	bool mSelectedFlag;
  	bool mGrabbedFlag;
  	
  	RRGrid2 mGrabbedPos;
  	RRGrid2 mGrabbedPtr; 
  	
  protected:
  
  	virtual void mfMoveTo(const RRGrid2& p);
  	virtual void mfShowBoundingBox();
  	virtual void mfHideBoundingBox();
  	
  	virtual RRStatus mfSelectedAction(const RREvent& e);
  	// Called when this handle is selected.
  	
  	virtual RRStatus mfUnselectedAction(const RREvent& e);
  	// Called when this handle is unselected.
  	
  	virtual RRStatus mfGrabbedAction(const RREvent& e);
  	// Called when this handle is grabbed.
  	
  	virtual RRStatus mfUngrabbedAction(const RREvent& e);
  	// Called when this handle is ungrabbed.
  	
  	virtual RRStatus mfDraggedAction(const RREvent& e);
  	// Called when this handle is dragged.
 
	virtual bool mfIsHit(
			const RREvent& e)const;

   	virtual RRStatus mfHandleEvent(
			const RREvent& e);

	void mfSetBL(const RRGrid2& bl){mBL=bl;}
	void mfSetTR(const RRGrid2& tr){mTR=tr;}

 public:
  
  	RRMobileRectHandler(
			RREventHandler *pa,
			const RRGrid2& bl,
			const RRGrid2& tr,
			const int bmargin);
  	// Every RRMobileRectHandler must be constructed with a certain parent.
  	 
  	RRMobileRectHandler(
			const RRMobileRectHandler& x);
  	// A copy constructor.
  	
  	virtual ~RRMobileRectHandler();
  	
  	const RRMobileRectHandler& operator=(
			const RRMobileRectHandler& x);

	virtual bool isHit(const RRGrid2& p)const;
};
    
#endif // _RR_MOBILE_RECT_HANDLER_H

//-------------------------------------------------------------------=72
// End of RRMobileRectHandler.h
//-------------------------------------------------------------------=72
