//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRMobileRectHandler.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "RRMobileRectHandler.h"

void RRMobileRectHandler::mfMoveTo(const RRGrid2& p)
{
	RRGrid2 def=mTR-mBL;
	mBL=mGrabbedPos+(p-mGrabbedPtr);
	mTR=mBL+def;
	mfGetBBox().renew(mBL,mTR);
}

void RRMobileRectHandler::mfShowBoundingBox()
{
	mfGetBBox().setVisible(true);
}

void RRMobileRectHandler::mfHideBoundingBox()
{
	mfGetBBox().setVisible(false);
}

RRStatus RRMobileRectHandler::mfSelectedAction(
			const RREvent& e)
{
	mSelectedFlag=true;
	mGrabbedFlag=false;
	mfShowBoundingBox();
	return RR_LOCKED;
}
  	
RRStatus RRMobileRectHandler::mfUnselectedAction(
			const RREvent& e)
{
	mSelectedFlag=false;
	mGrabbedFlag=false;
	mfHideBoundingBox();
	return RR_UNLOCKED;
}
  	
RRStatus RRMobileRectHandler::mfGrabbedAction(
			const RREvent& e)
{
	mSelectedFlag=true;
	mGrabbedFlag=true;
	mGrabbedPos=mBL;
	mGrabbedPtr=e.pos;
	return RR_SUCCESS;
}
  	
RRStatus RRMobileRectHandler::mfUngrabbedAction(
			const RREvent& e)
{
	mSelectedFlag=true;
	mGrabbedFlag=false;
	return RR_SUCCESS;
}
  	
RRStatus RRMobileRectHandler::mfDraggedAction(
			const RREvent& e)
{
	mfMoveTo(e.pos);	
	return RR_SUCCESS;
}
  
bool RRMobileRectHandler::mfIsHit(
			const RREvent& e)const
{
	return mfGetBBox().isHit(e.pos);
}
	  
bool RRMobileRectHandler::isHit(
			const RRGrid2& p)const
{
	return mfGetBBox().isHit(p);
}
	  
RRStatus RRMobileRectHandler::mfHandleEvent(
			const RREvent& e)
{
	if(mSelectedFlag==false)
	{
		if(e.type==RREVENT_PUSH_LBUTTON && 
		   mfGetBBox().isHit(e.pos))
			return mfSelectedAction(e);
		else
			return RR_ERROR;
	}
	else if(mGrabbedFlag==true)
	{
		if(e.type==RREVENT_RELEASE_LBUTTON)
			return mfUngrabbedAction(e);
		else if(e.type==RREVENT_MOTION_NOTIFY)
			return mfDraggedAction(e);
		else
			return RR_ERROR;
	}
	else
	{
		if(e.type==RREVENT_PUSH_LBUTTON && 
		   mfGetBBox().isHit(e.pos))
			return mfGrabbedAction(e);
		else if((e.type==RREVENT_PUSH_LBUTTON && !mfGetBBox().isHit(e.pos)) ||
		        (e.type==RREVENT_PUSH_RBUTTON))
			return mfUnselectedAction(e);
		else
			return RR_ERROR;
	}
}
  	
RRMobileRectHandler::RRMobileRectHandler(
			RREventHandler *pa,
			const RRGrid2& bl,
			const RRGrid2& tr,
			const int bmargin)
:RREventHandler(pa,RRBoundingBox(bl,tr,bmargin)),
 mBL(bl),
 mTR(tr),
 mSelectedFlag(true),
 mGrabbedFlag(false)
{
	mfShowBoundingBox();
}
  	 
RRMobileRectHandler::RRMobileRectHandler(
			const RRMobileRectHandler& x)
:RREventHandler(x),
 mBL(x.mBL),
 mTR(x.mTR),
 mSelectedFlag(x.mSelectedFlag),
 mGrabbedFlag(x.mGrabbedFlag)
{}
  	
RRMobileRectHandler::~RRMobileRectHandler()
{}
  	
const RRMobileRectHandler& RRMobileRectHandler::operator=(
			const RRMobileRectHandler& x)
{
	RREventHandler::operator=(x);
	mBL=x.mBL;
	mTR=x.mTR;
 	mSelectedFlag=x.mSelectedFlag;
 	mGrabbedFlag=x.mGrabbedFlag;
 	return *this;
}

//-------------------------------------------------------------------=72
// End of RRMobileRectHandler.cpp
//-------------------------------------------------------------------=72
