//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RREventHandler.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#define _RR_EVENT_HANDLER_C

#include "RREventHandler.h"
	
RRStatus RREventHandler::mfHandleEventByChildren(
			const RREvent& e,
            RREventHandler **hit)
{
	RRStatus status=RR_ERROR;
	*hit=NULL;
	for(int i=0;i<mChild.getSize();i++)
	{
		if(mChild[i]==mLocking)
			continue;
		status=mChild[i]->handleEvent(e);
		if(status!=RR_ERROR)
		{	
			*hit=mChild[i];
			break;	
		}
	}
	return status;
}
	  	
RRStatus RREventHandler::handleEvent(
			const RREvent& e)
{
	RRStatus status=RR_ERROR;
	if(mLocking!=NULL)
	{
		status=mLocking->handleEvent(e);
		if(status!=RR_UNLOCKED)
			mLocking=mLocking;
		else
		{
			mLocking=NULL;
			RREventHandler *hit;
			status=mfHandleEventByChildren(e,&hit);
			if(status==RR_LOCKED)
				mLocking=hit;
			else if(status==RR_SUCCESS)
			{
				mLocking=NULL;
				status=RR_UNLOCKED;
			}
			else
			{
				status=mfHandleEvent(e);
				if(status!=RR_LOCKED)
					status=RR_UNLOCKED;
			}	
		}
	}
	else
	{
		RREventHandler *hit;
		status=mfHandleEventByChildren(e,&hit);
		if(status==RR_LOCKED)
			mLocking=hit;
		else if(status==RR_SUCCESS)
			mLocking=NULL;
		else
			status=mfHandleEvent(e);
	}
	return status;
}

int RREventHandler::addChild(
			RREventHandler *c)
{
	return mChild.insert(mChild.getSize(),c);
}
  	
int RREventHandler::removeChild(
			RREventHandler *c)
{
	int i=0;
	while(mChild[i]!=c && i<mChild.getSize())
		i++;
	assert(i<mChild.getSize());

	if(i<mChild.getSize())
		return mChild.remove(i);
	else
		return mChild.getSize();
}
  
RREventHandler::RREventHandler(
			RREventHandler *pa)
:mParent(pa),
 mChild(),
 mLocking(NULL),
 mBBox()
{
	if(mParent!=NULL)
		mParent->addChild(this);
}
  
RREventHandler::RREventHandler(
			RREventHandler *pa,
			const RRBoundingBox& bbox)
:mParent(pa),
 mChild(),
 mLocking(NULL),
 mBBox(bbox)
{
	if(mParent!=NULL)
		mParent->addChild(this);
}
  	 	 
RREventHandler::RREventHandler(
			const RREventHandler& x)
:mParent(x.mParent),
 mChild(x.mChild),
 mLocking(x.mLocking),
 mBBox(x.mBBox)
{
	if(mParent!=NULL)
		mParent->addChild(this);
}
  	
RREventHandler::~RREventHandler()
{
	if(mParent!=NULL)
		mParent->removeChild(this);
}

const RREventHandler& RREventHandler::operator=(
			const RREventHandler& x)
{
	mParent->removeChild(this);
	mParent=x.mParent;
 	mChild=x.mChild;
 	mLocking=x.mLocking;
	mBBox=x.mBBox;
	mParent->addChild(this);
 	return *this;
}

//-------------------------------------------------------------------=72
// End of RREventHandler.cpp
//-------------------------------------------------------------------=72
