//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRDraggingPointerHandler.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// RRDraggingPointerHandler class is a RREventHandler class which is 
// specialized for handling a dragging pointer in a view window. 
// RRDraggingPointerHandler responses anytime when the pointer is dragged
// in the Bounding Box.
//
//-------------------------------------------------------------------=72

#ifndef _RR_DRAGGING_POINTER_HANDLER_H
#define _RR_DRAGGING_POINTER_HANDLER_H

#include "RREventHandler.h"

class RRDraggingPointerHandler : public RREventHandler
{
  private:
  
  	bool mGrabbedFlag;
  	
  	RRGrid2 mGrabbedPtr; 
  	
  protected:
  
  	virtual void mfShowBoundingBox();
  	virtual void mfHideBoundingBox();
  	
  	virtual RRStatus mfGrabbedAction(const RREvent& e);
  	// Called when this handle is grabbed.
  	
  	virtual RRStatus mfUngrabbedAction(const RREvent& e);
  	// Called when this handle is ungrabbed.
  	
  	virtual RRStatus mfDraggedAction(const RREvent& e);
  	// Called when this handle is dragged.
 
	virtual bool mfIsHit(
			const RREvent& e)const;

   	virtual RRStatus mfHandleEvent(
			const RREvent& e);

	RRGrid2 mfGetGrabbedPtr()const{return mGrabbedPtr;}
	void mfSetGrabbedPtr(const RRGrid2& pos){mGrabbedPtr=pos;}

 public:
  
  	RRDraggingPointerHandler(
			RREventHandler *pa,
			const RRGrid2& bl, 
			const RRGrid2& tr,  
			const int bmargin);
  	// Every RRDraggingPointerHandler must be constructed with a certain parent.
  	 
  	RRDraggingPointerHandler(
			const RRDraggingPointerHandler& x);
  	// A copy constructor.
  	
  	virtual ~RRDraggingPointerHandler();
  	
  	const RRDraggingPointerHandler& operator=(
			const RRDraggingPointerHandler& x);

	virtual bool isHit(const RRGrid2& p)const;
};
    
#endif // _RR_DRAGGING_POINTER_HANDLER_H

//-------------------------------------------------------------------=72
// End of RRDraggingPointerHandler.h
//-------------------------------------------------------------------=72
