//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRDraggingPointerHandler.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#define _ELD_DRAGGING_POINTER_HANDLER_C

#include "RRDraggingPointerHandler.h"

void RRDraggingPointerHandler::mfShowBoundingBox()
{
	mfGetBBox().setVisible(true);
}

void RRDraggingPointerHandler::mfHideBoundingBox()
{
	mfGetBBox().setVisible(false);
}
  	
RRStatus RRDraggingPointerHandler::mfGrabbedAction(
			const RREvent& e)
{
	mGrabbedFlag=true;
	mGrabbedPtr=e.pos;
	return RR_LOCKED;
}
  	
RRStatus RRDraggingPointerHandler::mfUngrabbedAction(
			const RREvent& e)
{
	mGrabbedFlag=false;
	return RR_UNLOCKED;
}
  	
RRStatus RRDraggingPointerHandler::mfDraggedAction(
			const RREvent& e)
{
	return RR_SUCCESS;
}
 
bool RRDraggingPointerHandler::mfIsHit(
			const RREvent& e)const
{
	return mfGetBBox().isHit(e.pos);
}

RRStatus RRDraggingPointerHandler::mfHandleEvent(
			const RREvent& e)
{
	if(mGrabbedFlag==true)
	{
		if(e.type==RREVENT_RELEASE_LBUTTON)
			return mfUngrabbedAction(e);
		else if(e.type==RREVENT_MOTION_NOTIFY)
			return mfDraggedAction(e);
		else
			return RR_ERROR;
	}
	else
	{
		if(e.type==RREVENT_PUSH_LBUTTON && 
		   mfGetBBox().isHit(e.pos))
			return mfGrabbedAction(e);
		else
			return RR_ERROR;
	}
}

RRDraggingPointerHandler::RRDraggingPointerHandler(
			RREventHandler *pa,
			const RRGrid2& bl, 
			const RRGrid2& tr,  
			const int bmargin)
:RREventHandler(pa,RRBoundingBox(bl,tr,bmargin)),
 mGrabbedFlag(false)
{
	mfShowBoundingBox();
}
  	 
RRDraggingPointerHandler::RRDraggingPointerHandler(
			const RRDraggingPointerHandler& x)
:RREventHandler(x),
 mGrabbedFlag(x.mGrabbedFlag)
{}

RRDraggingPointerHandler::~RRDraggingPointerHandler()
{}
  	
const RRDraggingPointerHandler& RRDraggingPointerHandler::operator=(
			const RRDraggingPointerHandler& x)
{
	RREventHandler::operator=(x);
 	mGrabbedFlag=x.mGrabbedFlag;
 	return *this;
}

bool RRDraggingPointerHandler::isHit(const RRGrid2& p)const
{
	return mfGetBBox().isHit(p);
}

    
//-------------------------------------------------------------------=72
// End of RRDraggingPointerHandler.cpp
//-------------------------------------------------------------------=72
