//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRBoundingBox.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// The RRBoundingBox class is a 2-dimensional integer rectangle which 
// indicates "object area".
//
//-------------------------------------------------------------------=72

#ifndef _RR_BOUNDING_BOX_H
#define _RR_BOUNDING_BOX_H

#include "RRDef.h"
#include "RRGrid2.h"

const int RRD_BBOX_MARGIN = 3;

class RRBoundingBox
{
  private:

	RRGrid2 mBL; // Bottom Left position
	RRGrid2 mTR; // Top Right position
	int mMargin;

	bool mVisibleFlag;
	
  private:
  
	RRStatus mfRenew(
			int n, 
			const RRGrid2 *p, 
			int m);	

  public:
  

	RRBoundingBox();
	RRBoundingBox(const RRGrid2& p,int m=RRD_BBOX_MARGIN);
	RRBoundingBox(const RRGrid2& p1,const RRGrid2& p2,int m=RRD_BBOX_MARGIN);
	RRBoundingBox(int n,const RRGrid2 *p,int m=RRD_BBOX_MARGIN);
	RRBoundingBox(const RRBoundingBox& x);
	virtual ~RRBoundingBox();
	
	bool isHit(const RRGrid2& p)const;
	
	RRStatus renew(const RRGrid2& p);	
	RRStatus renew(
			const RRGrid2& p1,
			const RRGrid2& p2);	
	RRStatus renew(int n, const RRGrid2 *p);	
	// Use current magin.
	RRStatus renew(int n, const RRGrid2 *p, int m);	
	// Use given m as margin.

	void setVisible(bool b);
	bool getVisible()const;

	void getRect(
			RRGrid2& b,
			RRGrid2& t)const{b=mBL;t=mTR;}
	const RRGrid2& getBL()const{return mBL;}
	const RRGrid2& getTR()const{return mTR;}
	void getSize(int& xs,int& ys)const{xs=mTR.getX()-mBL.getX();ys=mTR.getY()-mBL.getY();}

	const RRBoundingBox& operator=(const RRBoundingBox& x);
	friend int operator==(const RRBoundingBox& x1,
						  const RRBoundingBox& x2);
};
    
#endif // _RR_BOUNDING_BOX_H

//-------------------------------------------------------------------=72
// End of RRBoundingBox.h
//-------------------------------------------------------------------=72
