//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRBoundingBox.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72


#include "RRBoundingBox.h"

#include <assert.h>

RRStatus RRBoundingBox::mfRenew(
			int n, 
			const RRGrid2 *p, 
			int m)
{
	assert(n>0);
	
	RRGrid2 b(p[0]),t(p[0]);
	for(int i=1;i<n;i++)
	{
		b.setX((b.getX()>p[i].getX())?p[i].getX():b.getX());
		b.setY((b.getY()>p[i].getY())?p[i].getY():b.getY());
		t.setX((t.getX()<p[i].getX())?p[i].getX():t.getX());
		t.setY((t.getY()<p[i].getY())?p[i].getY():t.getY());
	}
	b.setX(b.getX()-m);
	b.setY(b.getY()-m);
	t.setX(t.getX()+m);
	t.setY(t.getY()+m);

	mBL=b;
	mTR=t;	
	return RR_SUCCESS;
}

RRBoundingBox::RRBoundingBox()
:mBL(0,0),
 mTR(0,0),
 mMargin(RRD_BBOX_MARGIN),
 mVisibleFlag(false)
{}

RRBoundingBox::RRBoundingBox(
			const RRGrid2& p,
			int m)
:mMargin(m),
 mVisibleFlag(false)
{
	mfRenew(1,&p,mMargin);	
}

RRBoundingBox::RRBoundingBox(
			const RRGrid2& p1,
			const RRGrid2& p2,
			int m)
:mMargin(m),
 mVisibleFlag(false)
{
	RRGrid2 q[2];
	q[0]=p1;
	q[1]=p2;
	mfRenew(2,q,mMargin);	
}

RRBoundingBox::RRBoundingBox(
			int n, 
			const RRGrid2 *p, 
			int m)
:mMargin(m),
 mVisibleFlag(false)
{
	mfRenew(n,p,m);	
}

RRBoundingBox::RRBoundingBox(
			const RRBoundingBox& x)
:mBL(x.mBL),
 mTR(x.mTR),
 mMargin(x.mMargin),
 mVisibleFlag(x.mVisibleFlag)
{}

RRBoundingBox::~RRBoundingBox(){}
	
bool RRBoundingBox::isHit(
			const RRGrid2& p)const
{
	if(p.getX()>=mBL.getX() && 
	   p.getX()<=mTR.getX() && 
	   p.getY()>=mBL.getY() && 
	   p.getY()<=mTR.getY())
	{
		return true;
	}
	else
	{
		return false;
	}
}
	
RRStatus RRBoundingBox::renew(
			const RRGrid2& p)
{
	return mfRenew(1,&p,mMargin);
}	

RRStatus RRBoundingBox::renew(
			const RRGrid2& p1,
			const RRGrid2& p2)
{
	RRGrid2 q[2];
	q[0]=p1;
	q[1]=p2;
	return mfRenew(2,q,mMargin);	
}

RRStatus RRBoundingBox::renew(
			int n, 
			const RRGrid2 *p)
{
	return mfRenew(n,p,mMargin);
}	

RRStatus RRBoundingBox::renew(
			int n, 
			const RRGrid2 *p, 
			int m)
{
	RRStatus status=mfRenew(n,p,m);
	if(status==RR_SUCCESS)
		mMargin=m;
	return status;
}

void RRBoundingBox::setVisible(bool b)
{
	mVisibleFlag=b;
}

bool RRBoundingBox::getVisible()const
{
	return mVisibleFlag;
}

const RRBoundingBox& RRBoundingBox::operator=(
			const RRBoundingBox& x)
{
	mBL=x.mBL;
	mTR=x.mTR;
	mMargin=x.mMargin;
	mVisibleFlag=x.mVisibleFlag;
	return *this;	
}

int operator==(
			const RRBoundingBox& x1,
			const RRBoundingBox& x2)
{
	return (x1.mBL==x2.mBL &&
			x1.mTR==x2.mTR &&
			x1.mMargin==x2.mMargin &&
			x1.mVisibleFlag==x2.mVisibleFlag)?1:0;
}

//-------------------------------------------------------------------=72
// End of RRBoundingBox.cpp
//-------------------------------------------------------------------=72
