//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRProcess.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from RRProcess.h
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RRProcess is a module of operation.
//	RRProcess needs 1 or arbitrary number of RRData as input (mInput). 
//	And RRProcess output 1 RRData (mOutput).
//
//	< in data[0] >   -->
//	< in data[1] >   -->
//	  .		         --> < process > --> < out data >
//	  .		         -->
//	< in data[n-1] > -->
//
//
//-------------------------------------------------------------------=72

#ifndef _RR_PROCESS_H
#define _RR_PROCESS_H

#include "RRDef.h"
#include "RRData.h"
#include "RRArray.h"

class RRProcess
{
  protected:
    
    RRProcessTypeName mType;
    // same to class name
	 
    RRArray< RRData* > mInput;
    RRData *mOutput;

  protected:

    RRProcess(
			RRProcessTypeName t,
			const RRData *in,
			RRData *out);
	// Constructs a 1-input process.

	RRProcess(
			RRProcessTypeName t,
			const RRArray< RRData* >& in,
            RRData *out);
	// Constructs a multi-input process.
	
  public:
  	
  	virtual ~RRProcess();

	virtual RRStatus doIt() = 0; 
	// Operates the process.
};

#endif // _RR_PROCESS_H

//-------------------------------------------------------------------=72
// End of RRProcess.h
//-------------------------------------------------------------------=72
