//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRProcess.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from RRProcess.cpp
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "RRProcess.h"

RRProcessTypeName RRPTN_D_PROCESS_TYPE_NAME = "nobody";

RRProcess::RRProcess(
			RRProcessTypeName t,
			const RRData *in,
			RRData *out)
:mType(t),
 mInput(1),
 mOutput(out)
{
	mInput[0]=(RRData*)in;
	mOutput->setCreator(mType);
	mOutput->setSource(in->getID());
}

RRProcess::RRProcess(
			RRProcessTypeName t,
			const RRArray< RRData* >& in,
            RRData *out)
:mType(t),
 mInput(in),
 mOutput(out)
{
	mOutput->setCreator(mType);
	for(int i=0;i<mInput.getSize();i++)
		mOutput->setSource(mInput[i]->getID());
}

RRProcess::~RRProcess()
{
	mType = RRPTN_D_PROCESS_TYPE_NAME;
}

//-------------------------------------------------------------------=72
// End of RRProcess.cpp
//-------------------------------------------------------------------=72
