//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRFiledData.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from RRFiledData.h
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	This file defines RRFiledData, RRROFiledData and RRWOFiledData class.
//
//	RRFiledData class is a RRDataTemplate class which has file I/O.
//	A certain file name must be specified when an instance is created.
//
//	RRROFiledData class is a RRFiledData class. The data in the specified
//	file is once read when the instance is created. Writing data to the 
//	file is protected.  
//
//	RRWOFiledData class is a RRFiledData class. The specified file is 
//	created when the instance is created. Reading data from the file is 
//	protected.
//
//-------------------------------------------------------------------=72

#ifndef _RR_FILED_DATA_H
#define _RR_FILED_DATA_H

#include "RRDef.h"
#include "RRDataTemplate.h"

#include <stdio.h>

template < class S >
class RRFiledData : public RRDataTemplate< S >
{
  protected:

	FILE *mFP;
	
  protected:
  	
  	RRStatus mfSave(FILE *fp)const;
  	RRStatus mfLoad(FILE *fp);
	
  public:

    RRFiledData(const char *filename, const char *mode);
	// a filename must be specified. mode is same to 
	// the mode of fopen().

    virtual ~RRFiledData(){fclose(mFP);}

  	RRStatus save()const{return mfSave(mFP);}
  	RRStatus load(){return mfLoad(mFP);}
};

template < class S >
class RRROFiledData : public RRFiledData< S >
{
  protected:
   
  	RRStatus save()const{return mfSave(mFP);}

  public:

    RRROFiledData(const char *filename):RRFiledData< S >(filename,"r")
    {rewind(mFP); mfLoad(mFP);}
	// open the file with read only mode. 

    virtual ~RRROFiledData(){}
};

template < class S >
class RRWOFiledData : public RRFiledData< S >
{
  protected:
   
  	RRStatus load(){return mfLoad(mFP);}

  public:

    RRWOFiledData(const char *filename):RRFiledData< S >(filename,"w"){}
	// open the file with write only mode.

    virtual ~RRWOFiledData(){rewind(mFP); mfSave(mFP);}
};


//
//
//

template < class S >
RRFiledData< S >::RRFiledData(const char *filename, const char *mode)
:RRDataTemplate< S >(filename)
{
	mFP=fopen(mID.getIndividual(),mode);
	assert(mFP);
}
    
template < class S >
RRStatus RRFiledData< S >::mfSave(FILE *fp)const
{
	fprintf(fp,"id\t%s\t%s\n",mID.getIndividual(),mID.getType());
	fprintf(fp,"creator\t%s\n",mCreator(0));
	fprintf(fp,"numSource\t%d\n",mSource.getSize());
	for(int i=0;i<mSource.getSize();i++)
		fprintf(fp,"source\t%d\t%s\t%s\n",i,mSource[i].getIndividual(),mSource[i].getType());
	mSubstance->save(fp);	
	return RR_SUCCESS;
}

template < class S >
RRStatus RRFiledData< S >::mfLoad(FILE *fp)
{
	char ind[64],typ[64],cre[64];
	
	fscanf(fp,"id\t%s\t%s\n",ind,typ);
	if(!(mID==RRDataID(ind,typ)))
	{
		fprintf(stderr,"RRFiledData::mfLoad:\terror\tID mismatch\n");
		return RR_ERROR;
	}
		
	fscanf(fp,"creator\t%s\n",cre);
	setCreator(cre);
 
	int size;
	fscanf(fp,"numSource\t%d\n",&size);
	mSource.setSize(size);
	int i,n;
	for(i=0;i<mSource.getSize();i++)
	{
		fscanf(fp,"source\t%d\t%s\t%s\n",&n,ind,typ);
		mSource[i]=RRDataID(ind,typ);
	}
	mSubstance->load(fp);	
	return RR_SUCCESS;
}

#endif // _RR_FILED_DATA_H

//-------------------------------------------------------------------=72
// End of RRFiledData.h
//-------------------------------------------------------------------=72
