//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRDataTemplate.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from RRDataTemplate.h
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RRDataTemplate is a template to create a RRData class with
//	a certain data type(substance).
//	
//-------------------------------------------------------------------=72

#ifndef _RR_DATA_TEMPLATE_H
#define _RR_DATA_TEMPLATE_H

#include "RRDef.h"
#include "RRData.h"
#include "RRDataSubstance.h"

#include <assert.h>

template < class S >
class RRDataTemplate : public RRData
{
  public:

    RRDataTemplate();
    RRDataTemplate(const RRDataTemplate< S >& x);
    RRDataTemplate(const char *individual);

  public:
  
  	virtual ~RRDataTemplate();

	virtual const RRDataTemplate< S >& operator=(
				const RRDataTemplate< S >& x);
};
    

//
// 
//
    
template < class S >
RRDataTemplate< S >::RRDataTemplate()
:RRData(RRDataID(RRDIN_D_DATA_INDIVIDUAL_NAME,S::getType()))
{
	mSubstance = new S;
}

template < class S >
RRDataTemplate< S >::RRDataTemplate(const RRDataTemplate< S >& x)
:RRData(x)
{
	mSubstance = new S;
	*mSubstance= *(x.mSubstance);
}

template < class S >
RRDataTemplate< S >::RRDataTemplate(const char *individual)
:RRData(RRDataID(individual,S::getType()))
{
	mSubstance = new S;
}

template < class S >
RRDataTemplate< S >::~RRDataTemplate()
{
	delete mSubstance;
}

template < class S >
const RRDataTemplate< S >& RRDataTemplate< S >::operator=(
				const RRDataTemplate< S >& x)
{
	delete mSubstance;
	mSubstance = new S;
	*mSubstance= *(x.mSubstance);

	return *this;
}
           
#endif // _RR_DATA_TEMPLATE_H

//-------------------------------------------------------------------=72
// End of RRDataTemplate.h
//-------------------------------------------------------------------=72
