//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRDataSubstance.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from RRDataSubstance.h
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	The RRDataSubstance class is the actual data part of a RRData class.
//
//	The RRDataSubstance class is an abstract base class. You can make
//	derivatives of RRDataSubstance to difine your specific data.  
//
//-------------------------------------------------------------------=72

#ifndef _RR_DATA_SUBSTANCE_H
#define _RR_DATA_SUBSTANCE_H

#include "RRDef.h"
#include "RRDataID.h"

#include <stdio.h>

class RRDataSubstance
{
  public:

    virtual ~RRDataSubstance();
    
    virtual RRStatus save(FILE *fp)const = 0;
	// save data to the file. 

    virtual RRStatus load(FILE *fp) = 0;
    // load data from the file.
	
    static const char *getType();
	// return class name.

    virtual const RRDataSubstance& operator=(const RRDataSubstance& s);
	
 	virtual bool operator==(const RRDataSubstance& x)const;	
};

#endif // _RR_DATA_SUBSTANCE_H

//-------------------------------------------------------------------=72
// End of RRDataSubstance.h
//-------------------------------------------------------------------=72
