//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRDataID.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldDataID.h	
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// This file defines the RRDataID class and RRProcessType class.
// RRDataID class is a part of a RRData class.
// mIndividualName is provided a different one to each individual data.
// mTypeName is provided a different one to each type(substance) of 
// data.
//
//-------------------------------------------------------------------=72

#ifndef _RR_DATA_ID_H
#define _RR_DATA_ID_H

#include "RRDef.h"

class RRDataID
{
  private:
  
	char mIndividualName[256];
	char mTypeName[256];

  public:
  

    RRDataIndividualName getIndividual()const;
    RRDataTypeName getType()const;  	
  
  	bool isSameIndividual(const RRDataID& x)const;
  	bool isSameType(const RRDataID& x)const;
    
    const RRDataID& operator=(const RRDataID& x);
    bool operator==(const RRDataID& x)const;
    
    RRDataID();
    RRDataID(const RRDataID& x);
    RRDataID(const char *in,const char *ty);
};

class RRProcessType
{
  private:
  
	char mTypeName[256];

  public:
  
    const RRProcessType& operator=(const RRProcessType& x);
    bool operator==(const RRProcessType& x)const;

    RRProcessType();
    RRProcessType(const RRProcessType& x);
    RRProcessType(const char *ty);

	const char *operator()(int n)const{return &(mTypeName[n]);}
};

#endif // _RR_DATA_ID_H

//-------------------------------------------------------------------=72
// End of RRDataID.h
//-------------------------------------------------------------------=72

	