//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRDataID.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldDataID.cpp	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "RRDataID.h"

#include <string.h>

RRDataIndividualName RRDIN_D_DATA_INDIVIDUAL_NAME = "nobody";
RRDataTypeName RRDTN_D_DATA_TYPE_NAME = "nobody";

RRDataIndividualName RRDataID::getIndividual()const
{return mIndividualName;}
    
RRDataTypeName RRDataID::getType()const
{return mTypeName;}  	

bool RRDataID::isSameIndividual(const RRDataID& x)const
{
	return (strcmp(mIndividualName,x.mIndividualName)==0)?
		true:false;
}

bool RRDataID::isSameType(const RRDataID& x)const
{
	return (strcmp(mTypeName,x.mTypeName)==0)?
		true:false;
}

bool RRDataID::operator==(const RRDataID& x)const
{
	return (isSameIndividual(x) && isSameType(x))?
		true:false;
}

const RRDataID& RRDataID::operator=(const RRDataID& x)
{
	strcpy(mIndividualName,x.mIndividualName);
	strcpy(mTypeName,x.mTypeName);
	return *this;
}

RRDataID::RRDataID(RRDataIndividualName in,RRDataTypeName ty)
{
	strcpy(mIndividualName,in);
	strcpy(mTypeName,ty);
}

RRDataID::RRDataID()
{
	strcpy(mIndividualName,RRDIN_D_DATA_INDIVIDUAL_NAME);
	strcpy(mTypeName,RRDTN_D_DATA_TYPE_NAME);
}

RRDataID::RRDataID(const RRDataID& x)
{
	strcpy(mIndividualName,x.mIndividualName);
	strcpy(mTypeName,x.mTypeName);
}

//-------------------------------------------------------------------=72
// RRProcessType
//-------------------------------------------------------------------=72

bool RRProcessType::operator==(const RRProcessType& x)const
{
	return (strcmp(mTypeName,x.mTypeName)==0)?true:false;
}

const RRProcessType& RRProcessType::operator=(const RRProcessType& x)
{
	strcpy(mTypeName,x.mTypeName);
	return *this;
}

RRProcessType::RRProcessType(const char *ty)
{
	strcpy(mTypeName,ty);
}

RRProcessType::RRProcessType()
{
	strcpy(mTypeName,RRPTN_D_PROCESS_TYPE_NAME);
}

RRProcessType::RRProcessType(const RRProcessType& x)
{
	strcpy(mTypeName,x.mTypeName);
}

//-------------------------------------------------------------------=72
// End of RRDataID.cpp
//-------------------------------------------------------------------=72
