//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRData.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldData.h	
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RRData class is a common data structure which is used as input
//	or output data of RRProcess. 
//	
//	< in data[0] >   -->
//	< in data[1] >   -->
//	  .		         --> < process > --> < out data >
//	  .		         -->
//	< in data[n-1] > -->
//
//  mID specifies the name and the type of a data.
//  mCreator specifies the type of < process > for < out data >.
//	mSource specify IDs of < in data[i] > for < out data >.
//
//	RRData may have an arbitrary data type. mSubstance is the actual
//	data part.
//
//-------------------------------------------------------------------=72

#ifndef _RR_DATA_H
#define _RR_DATA_H

#include "RRDef.h"
#include "RRDataID.h"
#include "RRArray.h"
#include "RRDataSubstance.h"

class RRData
{
  protected:

	const RRDataID mID;

    RRProcessType mCreator;
    RRArray< RRDataID > mSource;
    RRDataSubstance *mSubstance;
    
  private:
  
  	const RRData& operator=(
			const RRData& x){return *this;} // Don't use.

  protected:

    // Don't let these public!
    RRData();
    RRData(const RRData& x);
    RRData(const RRDataID& i);

  public:
  
	virtual ~RRData();
  
  	bool isSameType(const RRData& x)const;

    const RRDataSubstance& getSubstance()const;
    RRDataSubstance& getSubstance();
    // returns the reference to substance.
	// used to get access to actual data.

    const RRDataID& getSource(int n) const;
    // This returns the reference to source[n] if it exist.
    // this is aborted by assert() if not.

	const RRDataID& getID()const;
    void setCreator(RRProcessTypeName ptype);
    int setSource(const RRDataID& src);
};
    
#endif // _RR_DATA_H

//-------------------------------------------------------------------=72
// End of RRData.h
//-------------------------------------------------------------------=72
