//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRData.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldData.cpp	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "RRData.h"

#include <assert.h>

RRData::RRData()
:mID(RRDataID()),
 mCreator(RRPTN_D_PROCESS_TYPE_NAME),
 mSource(0),
 mSubstance(NULL)
{
	mSubstance=NULL;
}

RRData::RRData(const RRData& x)
:mID(x.mID),
 mCreator(x.mCreator),
 mSource(0),
 mSubstance(NULL)
{}

RRData::RRData(const RRDataID& i)
:mID(i),
 mCreator(RRPTN_D_PROCESS_TYPE_NAME),
 mSource(0),
 mSubstance(NULL)
{}

RRData::~RRData()
{
	mSubstance=NULL;
}
  
bool RRData::isSameType(const RRData& x)const
{
	return mID.isSameType(x.mID);
}

const RRDataSubstance& RRData::getSubstance()const
{
	return *mSubstance;
}

RRDataSubstance& RRData::getSubstance()
{
	return *mSubstance;
}

const RRDataID& RRData::getSource(int n) const
{
	assert(n>=0 && n<mSource.getSize());
	
	return mSource[n];
}

const RRDataID& RRData::getID()const
{
	return mID;
}
    
void RRData::setCreator(RRProcessTypeName ptype)
{
	mCreator=RRProcessType(ptype);
}

int RRData::setSource(const RRDataID& src)
{
	return mSource.insert(mSource.getSize(),src);
}


//-------------------------------------------------------------------=72
// End of RRData.cpp
//-------------------------------------------------------------------=72
