//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// MainFrm.cpp : implementation of the CMainFrame class
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "stdafx.h"
#include "imageAlignment.h"

#include "MainFrm.h"
#include "IAView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_VIEW_REF, OnViewRef)
	ON_COMMAND(ID_VIEW_DEST, OnViewDest)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	CMenu* menu=GetMenu( );
	menu->CheckMenuItem(ID_VIEW_REF,MF_CHECKED);
	mMenuViewRefChecked=MF_UNCHECKED;
	menu->CheckMenuItem(ID_VIEW_DEST,MF_CHECKED);
	mMenuViewDestChecked=MF_UNCHECKED;

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

void CMainFrame::OnViewRef() 
{
	// TODO: Add your command handler code here
	if(mMenuViewRefChecked==MF_UNCHECKED && mMenuViewDestChecked==MF_CHECKED)
		return; 

	CMenu* menu=GetMenu( );
	mMenuViewRefChecked=menu->CheckMenuItem(ID_VIEW_REF,mMenuViewRefChecked);

	CIAView *view=(CIAView*)GetActiveView();
	view->udp.setViewMode(mMenuViewRefChecked,mMenuViewDestChecked);
}

void CMainFrame::OnViewDest() 
{
	// TODO: Add your command handler code here
	if(mMenuViewRefChecked==MF_CHECKED && mMenuViewDestChecked==MF_UNCHECKED)
		return; 

	CMenu* menu=GetMenu( );
	mMenuViewDestChecked=menu->CheckMenuItem(ID_VIEW_DEST,mMenuViewDestChecked);

	CIAView *view=(CIAView*)GetActiveView();
	view->udp.setViewMode(mMenuViewRefChecked,mMenuViewDestChecked);	
}

//-------------------------------------------------------------------=72
// End of MainFrm.cpp : implementation of the CMainFrame class
//-------------------------------------------------------------------=72

