//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IAViewUserDefinePart.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#ifndef _IA_VIEW_USER_DEFINE_PART_H
#define _IA_VIEW_USER_DEFINE_PART_H

#include "WGLWindow.h"
#include "IABitmap.h"
#include "IAMobileRect.h"

class CIAView;

class IAViewUserDefinePart
{
  private:

	CIAView *mView;

	WGLWindow *mWglWindow;

	IABitmap mBitmap;
	RRArray< IAMobileRect* > mMobileRect;

	RRGrid2 mScissorBL,mScissorSize;
	RRGrid2 mPreScissorBL,mPreScissorSize;
	float mBGColor[4];

  private:

	void mfSetView(CIAView *view){mView=view;}
 
  public:

	IAViewUserDefinePart();
	~IAViewUserDefinePart();	

	bool preCreateWindow(CREATESTRUCT& cs);
	void onDraw();
	bool destroyWindow();
	int onCreate(
			LPCREATESTRUCT lpCreateStruct,
			CIAView *view);

	void setViewMode(
			const unsigned int refcheck,
			const unsigned int destcheck);
	void setRefBitmap();
	void setDestBitmap();
	void changeBGColor();

	RRStatus addMobileRect(IAMobileRect *mr);
	RRStatus removeMobileRect(IAMobileRect *mr);

	void scissorRect(IAMobileRect *mr);

};

#endif // _IA_VIEW_USER_DEFINE_PART_H

//-------------------------------------------------------------------=72
// End of IAViewUserDefinePart.h
//-------------------------------------------------------------------=72
