//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IAViewUserDefinePart.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "stdafx.h"

#include <afxwin.h>         // MFC core and standard components

#include <gl\gl.h>
#include <gl\glu.h>

#include "IAView.h"
#include "IAViewUserDefinePart.h"

const int IAVUDP_RedrawMargin = 1;

IAViewUserDefinePart::IAViewUserDefinePart()
:mWglWindow(NULL)
{
	mBGColor[0]=mBGColor[1]=mBGColor[2]=mBGColor[3]=1.;
}

IAViewUserDefinePart::~IAViewUserDefinePart()	
{
	delete mWglWindow;
}

bool IAViewUserDefinePart::preCreateWindow(
			CREATESTRUCT& cs)
{
	// Add Window styles required for OpenGL before window is created
	cs.style |= (WS_CLIPCHILDREN | WS_CLIPSIBLINGS | CS_OWNDC);
	glDisable(GL_SCISSOR_TEST);

	return true;
}

void IAViewUserDefinePart::onDraw()
{
	// Make the rendering context current
	mWglWindow->MakeCurrent();

	// Set view port
	RECT rect;
    mView->GetClientRect(&rect);
	mWglWindow->setViewport(rect);

	glScissor(mPreScissorBL.getX(),
	          mPreScissorBL.getY(),
			  mPreScissorSize.getX(),
	          mPreScissorSize.getY());

	// Clear background color
	//glClearColor(float(rand())/RAND_MAX,float(rand())/RAND_MAX,float(rand())/RAND_MAX,float(1.0));
	glClearColor(mBGColor[0],mBGColor[1],mBGColor[2],mBGColor[3]);
	glClear(GL_COLOR_BUFFER_BIT);

	// Call our external OpenGL code
	mBitmap.renderObject();
	for(int i=0;i<mMobileRect.getSize();i++)
		mMobileRect[i]->renderObject();
	
	glScissor(mScissorBL.getX(),
	          mScissorBL.getY(),
			  mScissorSize.getX(),
	          mScissorSize.getY());

	// Clear background color
	//glClearColor(float(rand())/RAND_MAX,float(rand())/RAND_MAX,float(rand())/RAND_MAX,float(1.0));
	glClearColor(mBGColor[0],mBGColor[1],mBGColor[2],mBGColor[3]);
	glClear(GL_COLOR_BUFFER_BIT);

	// Call our external OpenGL code
	mBitmap.renderObject();
	for(i=0;i<mMobileRect.getSize();i++)
		mMobileRect[i]->renderObject();

	// Swap our scene to the front
	mWglWindow->SwapBuffers();

	// Allow other rendering contexts to co-exist
	mWglWindow->MakeCurrent();
}

bool IAViewUserDefinePart::destroyWindow()
{
	// Clean up rendering context stuff
	delete mWglWindow;
	mWglWindow=NULL;
	return true;
}

int IAViewUserDefinePart::onCreate(
			LPCREATESTRUCT lpCreateStruct,
			CIAView *view)
{
	mfSetView(view);
	mWglWindow = new WGLWindow(view->m_hWnd);

	mBitmap.setMode(IAB_BLEND);
	return 0;
}
 

void IAViewUserDefinePart::setRefBitmap()
{
	CIADoc* pDoc = mView->GetDocument();
	ASSERT_VALID(pDoc);

	mBitmap.setRefBitmap(pDoc);
}

void IAViewUserDefinePart::setDestBitmap()
{
	CIADoc* pDoc = mView->GetDocument();
	ASSERT_VALID(pDoc);

	mBitmap.setDestBitmap(pDoc);
}

void IAViewUserDefinePart::changeBGColor()
{
	mBGColor[0]=float(rand())/RAND_MAX;
	mBGColor[1]=float(rand())/RAND_MAX;
	mBGColor[2]=float(rand())/RAND_MAX;
	mBGColor[3]=float(rand())/RAND_MAX;
}

RRStatus IAViewUserDefinePart::addMobileRect(
			IAMobileRect *mr)
{
	mMobileRect.insert(0,mr);
	return RR_SUCCESS;
}

RRStatus IAViewUserDefinePart::removeMobileRect(
			IAMobileRect *mr)
{
	for(int i=0;i<mMobileRect.getSize();i++)
	{
		if(mMobileRect[i]==mr)
		{
			mMobileRect.remove(i);
			return RR_SUCCESS;
		}
	}
	return RR_ERROR;
}

void IAViewUserDefinePart::scissorRect(
			IAMobileRect *mr)
{
	if(mr==NULL)
	{
		mPreScissorBL=mScissorBL=RRGrid2(0,0);
		mPreScissorSize=mScissorSize=RRGrid2(0,0);
		glDisable(GL_SCISSOR_TEST);	
	}
	else
	{
		RRBoundingBox bbox=mr->getBBox();
		mPreScissorBL=mScissorBL;
		mPreScissorSize=mScissorSize;
		mScissorBL=bbox.getBL();
		mScissorSize=bbox.getTR()-bbox.getBL();
		glEnable(GL_SCISSOR_TEST);
	}
}

void IAViewUserDefinePart::setViewMode(
			const unsigned int refcheck,
			const unsigned int destcheck)
{
	if(refcheck!=0 && destcheck==0)
		mBitmap.setMode(IAB_DEST);
	else if(refcheck==0 && destcheck!=0)
		mBitmap.setMode(IAB_REF);
	else
		mBitmap.setMode(IAB_BLEND);

	glDisable(GL_SCISSOR_TEST);
	onDraw();
}

//-------------------------------------------------------------------=72
// End of IAViewUserDefinePart.cpp
//-------------------------------------------------------------------=72

