//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IAView.h : interface of the CIAView class
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#if !defined(AFX_IAVIEW_H__F9AEFD73_4DA0_11D2_8268_0020AFF0DB59__INCLUDED_)
#define AFX_IAVIEW_H__F9AEFD73_4DA0_11D2_8268_0020AFF0DB59__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "IAViewUserDefinePart.h"
#include "IARootHandler.h"

class CIAView : public CView
{
protected: // create from serialization only
	CIAView();
	DECLARE_DYNCREATE(CIAView)

// Attributes
public:
	CIADoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CIAView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CIAView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CIAView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

  public:

	IAViewUserDefinePart udp;
	IARootHandler reh;
};

#ifndef _DEBUG  // debug version in IAView.cpp
inline CIADoc* CIAView::GetDocument()
   { return (CIADoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_IAVIEW_H__F9AEFD73_4DA0_11D2_8268_0020AFF0DB59__INCLUDED_)

//-------------------------------------------------------------------=72
// End of IAView.h : interface of the CIAView class
//-------------------------------------------------------------------=72
