//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IATransformParameterData.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#ifndef _IA_TRANSFORM_PARAMETER_DATA_H
#define _IA_TRANSFORM_PARAMETER_DATA_H

#include "RRDef.h"
#include "RRDataSubstance.h"

class IATransformParameterData : public RRDataSubstance
{
  private:

	double mRotation;
	double mTranslationX;
	double mTranslationY;	

  public:

	IATransformParameterData();

	static const char *getType(){return "IATransformParameterData";}

	double getRotation()const{return mRotation;}
	RRStatus setRotation(const double rot){mRotation=rot;return RR_SUCCESS;}
	double getTranslationX()const{return mTranslationX;}
	RRStatus setTranslationX(const double tx){mTranslationX=tx;return RR_SUCCESS;}
	double getTranslationY()const{return mTranslationY;}
	RRStatus setTranslationY(const double ty){mTranslationY=ty;return RR_SUCCESS;}
	  
    virtual RRStatus save(FILE *fp)const;
    virtual RRStatus load(FILE *fp);

    //virtual const RRDataSubstance& operator=(const RRDataSubstance& s);
	//virtual int operator==(const RRDataSubstance& x)const;	
    const IATransformParameterData& operator=(const IATransformParameterData& s);
	int operator==(const IATransformParameterData& x)const;
};

#endif // _IA_TRANSFORM_PARAMETER_DATA_H

//-------------------------------------------------------------------=72
// End of IATransformParameterData.h
//-------------------------------------------------------------------=72
