//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IATransformParameterData.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#define _IA_TRANSFORM_PARAMETER_DATA_C

#include "IATransformParameterData.h"

IATransformParameterData::IATransformParameterData()
:mRotation(0.),
 mTranslationX(0.),
 mTranslationY(0.)
{}

RRStatus IATransformParameterData::save(
			FILE *fp)const
{
	fprintf(fp,"rotation\t%le\n",mRotation);
	fprintf(fp,"translationX\t%le\n",mTranslationX);
	fprintf(fp,"translationY\t%le\n",mTranslationY);
	return RR_SUCCESS;
}

RRStatus IATransformParameterData::load(
			FILE *fp)
{
	fscanf(fp,"rotation\t%le\n",&mRotation);
	fscanf(fp,"translationX\t%le\n",&mTranslationX);
	fscanf(fp,"translationY\t%le\n",&mTranslationY);
	return RR_SUCCESS;
}

const IATransformParameterData& IATransformParameterData::operator=(
			const IATransformParameterData& s)
{
	mRotation=s.mRotation;
	mTranslationX=s.mTranslationX;
	mTranslationY=s.mTranslationY;
	return *this;
}

int IATransformParameterData::operator==(
			const IATransformParameterData& x)const
{
	return (mRotation==x.mRotation &&
	        mTranslationX==x.mTranslationX &&
			mTranslationY==x.mTranslationY)?1:0;
}

//-------------------------------------------------------------------=72
// End of IATransformParameterData.cpp
//-------------------------------------------------------------------=72
