//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IATransParamEstimation.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#ifndef _IA_TRANS_PARAM_ESTIMATION_H
#define _IA_TRANS_PARAM_ESTIMATION_H

#include "RRProcess.h"
#include "RRGridArrayData.h"
#include "IATransformParameterData.h"

class IATransParamEstimation : public RRProcess
{
  private:

  private:

	RRStatus mfCalcParameters(
			const RRArray< RRGrid2 >& p,
			const RRArray< RRGrid2 >& q,
			double& rot,
			double& tx,
			double& ty);

  public:

    IATransParamEstimation(
			const RRArray< RRData* >& in,	// RRGridArrayData -> in[0]
											// RRGridArrayData -> in[1]
			RRData *out);	                // IATransformParameterData

	RRStatus doIt();
};

#endif // _IA_TRANS_PARAM_ESTIMATION_H

//-------------------------------------------------------------------=72
// End of IATransParamEstimation.h
//-------------------------------------------------------------------=72
