//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IATempMatch.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#ifndef _RR_UTIL_TEMPMATCH_H
#define _RR_UTIL_TEMPMATCH_H

#include "RRDef.h"
//#include "RRImage.h"
#include "RRField.h"
#include "RRPixelD.h"
#include "RRGrid2.h"

class RRUtilTempMatch
{
  private:

	static RRStatus 
	mfTestSquareError(
			//const RRImage& templateimg,
			const RRField< RRPixelD >& templateimg,
			//const RRImage& rect,
			const RRField< RRPixelD >& rect,
			double& squareerror);

	static RRStatus 
	mfNoirmalizeImage(
			//const RRImage& src,
			const RRField< RRPixelD >& src,
			//RRImage& dest);
			RRField< RRPixelD >& dest);
  public:
  
    static RRStatus
	getSubImage(
			//const RRImage& source,
			const RRField< RRPixelD >& source,
			const int xorigin,
			const int yorigin,
			const int xsize,
			const int ysize,
			//RRImage& subimg);
			RRField< RRPixelD >& subImage);

	static RRStatus
	templateMatching(
			//const RRImage& templateimg,
			const RRField< RRPixelD >& templateimg,
			//const RRImage& searcharea,
			const RRField< RRPixelD >& searcharea,
			int& matchx,
			int& matchy,
			double& meansquareerror);
};
    
#endif // _RR_UTIL_TEMPMATCH_H

//-------------------------------------------------------------------=72
// End of RRUtilTempMatch.h
//-------------------------------------------------------------------=72
