//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IATempMatch.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "IATempMatch.h"
//#include "RRImageFileIO.h"

#include <math.h>

RRStatus RRUtilTempMatch::getSubImage(
			//const RRImage& source,
			const RRField< RRPixelD >& source,
			const int xorigin,
			const int yorigin,
			const int xsize,
			const int ysize,
			//RRImage& subimg)
			RRField< RRPixelD >& subimg)
{
	int xs,ys;
	source.getSize(xs,ys);
	subimg.setSize(xsize,ysize);

	for(int dy=0;dy<xsize;dy++)
		for(int dx=0;dx<ysize;dx++)
		{
			int sx=xorigin+dx;
			int sy=yorigin+dy;

			if(sx<0 || sx>=xs || sy<0 || sy>=ys)
				//subimg.setPixelB(dx,dy,RRPixelB(0,0,0,255));
				subimg.setElem(dx,dy,RRPixelD(0,0,0,1));
			else
				//subimg.setPixelB(dx,dy,source.getPixelB(sx,sy));
				subimg.setElem(dx,dy,source.getElem(sx,sy));
		}

    return RR_SUCCESS;
}

RRStatus RRUtilTempMatch::mfTestSquareError(
			//const RRImage& templateimg,
			const RRField< RRPixelD >& templateimg,
			//const RRImage& rect,
			const RRField< RRPixelD >& rect,
			double& squareerror)
{
	int xs,ys;
	templateimg.getSize(xs,ys);
	int rxs,rys;
	rect.getSize(rxs,rys);
	assert(rxs==xs && rys==ys);

	double serr=0.;
	for(int y=0;y<ys;y++)
		for(int x=0;x<xs;x++)
		{
			//RRPixelD tpxl=templateimg.getPixelD(x,y);
			//RRPixelD rpxl=rect.getPixelD(x,y);
			RRPixelD tpxl=templateimg.getElem(x,y);
			RRPixelD rpxl=rect.getElem(x,y);
	
			double r=rpxl.getR()-tpxl.getR();
			double g=rpxl.getG()-tpxl.getG();
			double b=rpxl.getB()-tpxl.getB();
			serr+=r*r+g*g+b*b;

			if(serr>squareerror)
				return RR_ERROR;
		}

	squareerror=serr;
	return RR_SUCCESS;
}

RRStatus RRUtilTempMatch::mfNoirmalizeImage(
			//const RRImage& src,
			const RRField< RRPixelD >& src,
			//RRImage& dest)
			RRField< RRPixelD >& dest)
{
	int xs,ys;
	src.getSize(xs,ys);
	dest.setSize(xs,ys);

	double minr(1),ming(1),minb(1);
	double maxr(0),maxg(0),maxb(0);
	for(int y=0;y<ys;y++)
		for(int x=0;x<xs;x++)
		{
			//RRPixelD p=src.getPixelD(x,y);
			RRPixelD p=src.getElem(x,y);
			minr=(p.getR()<minr)?p.getR():minr;
			ming=(p.getG()<ming)?p.getG():ming;
			minb=(p.getB()<minb)?p.getB():minb;
			maxr=(p.getR()>maxr)?p.getR():maxr;
			maxg=(p.getG()>maxg)?p.getG():maxg;
			maxb=(p.getB()>maxb)?p.getB():maxb;
		}

	double normr(maxr-minr);
	double normg(maxg-ming);
	double normb(maxb-minb);
	for(y=0;y<ys;y++)
		for(int x=0;x<xs;x++)
		{
			//RRPixelD p=src.getPixelD(x,y);
			RRPixelD p=src.getElem(x,y);
			double r=(p.getR()-minr)/normr;
			double g=(p.getG()-ming)/normg;
			double b=(p.getB()-minb)/normb;
			//dest.setPixelD(x,y,RRPixelD(r,g,b,1.));
			dest.setElem(x,y,RRPixelD(r,g,b,1.));
		}

	return RR_SUCCESS;
}

RRStatus RRUtilTempMatch::templateMatching(
			//const RRImage& templateimg,
			const RRField< RRPixelD >& templateimg,
			//const RRImage& searcharea,
			const RRField< RRPixelD >& searcharea,
			int& matchx,
			int& matchy,
			double& meansquareerror)
{
	int txs,tys;
	templateimg.getSize(txs,tys);

	//RRImage normtemp;
	RRField< RRPixelD > normtemp;

	if(mfNoirmalizeImage(templateimg,normtemp)==RR_ERROR)
		return RR_ERROR;

	int sxs,sys;
	searcharea.getSize(sxs,sys);
	int xrange=sxs-txs;
	int yrange=sys-tys;

	double squareerror=HUGE_VAL;
	//RRImage rect;
	RRField< RRPixelD > rect;

    for(int y=0;y<=yrange;y++)
		for(int x=0;x<=xrange;x++)
		{
			if(RRUtilTempMatch::getSubImage(searcharea,
			                           x,
				   					   y,
									   txs,
									   tys,
									   rect)==RR_ERROR)
				return RR_ERROR;
                
			//RRImage normrect;
			RRField< RRPixelD > normrect;
			if(mfNoirmalizeImage(rect,normrect)==RR_ERROR)
				return RR_ERROR;

			if(mfTestSquareError(normtemp,
			                     normrect,
								 squareerror)==RR_SUCCESS)
			{
				matchx=x;
				matchy=y;
			}
 		}

	meansquareerror=squareerror/(txs*tys);
	return RR_SUCCESS;
}

//-------------------------------------------------------------------=72
// End of IATempMatch.cpp
//-------------------------------------------------------------------=72
