//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IARootHandler.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#ifndef _IA_ROOT_HANDLER_H
#define _IA_ROOT_HANDLER_H

#include "WinRootHandler.h"
#include "IAViewUserDefinePart.h"
#include "IADocUserDefinePart.h"

class IARootHandler : public WinRootHandler
{
  private:

	IAViewUserDefinePart *mVUdp;
	IADocUserDefinePart *mDUdp;

  protected:
  
  	virtual RRStatus mfHandleEvent(
				const RREvent& e);

	virtual RRStatus mfChangeBGColorAction();
	virtual RRStatus mfAddMatchingPointAction(
			const RREvent& e);
	virtual RRStatus mfRemoveMatchingPointAction(
			const RREvent& e);

  public:

  	IARootHandler();
  	IARootHandler(const IARootHandler& x);  	
  	virtual ~IARootHandler();
  	
	void setVUdp(IAViewUserDefinePart *vudp){mVUdp=vudp;}
	void setDUdp(IADocUserDefinePart *dudp){mDUdp=dudp;}

  	const IARootHandler& operator=(const IARootHandler& x);
};
    
#endif // _IA_ROOT_HANDLER_H

//-------------------------------------------------------------------=72
// End of IARootHandler.h
//-------------------------------------------------------------------=72
