//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IARootHandler.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#define _IA_ROOT_HANDLER_C

#include "stdafx.h"

#include "IARootHandler.h"
#include "IAMobileRectHandler.h"
#include "IAMatchingPoint.h"

RRStatus IARootHandler::mfHandleEvent(
				const RREvent& e)
{
	RRStatus status;
	if(e.type==RREVENT_PUSH_LBUTTON)
	{
		if(e.mod==RREVENT_MOD_CTRL)
			status=mfAddMatchingPointAction(e);
		else
			status=mfChangeBGColorAction();
	}
	else if(e.type==RREVENT_PUSH_RBUTTON)
	{
		if(e.mod==RREVENT_MOD_CTRL)
			status=mfRemoveMatchingPointAction(e);
	}

	return status;	
}

IARootHandler::IARootHandler()
:WinRootHandler(),
 mVUdp(NULL),
 mDUdp(NULL)
{}

IARootHandler::IARootHandler(const IARootHandler& x)
:WinRootHandler(x)
{
	setVUdp(x.mVUdp);
	setDUdp(x.mDUdp);
}
  	
IARootHandler::~IARootHandler()
{}
  	
const IARootHandler& IARootHandler::operator=(
			const IARootHandler& x)
{
	WinRootHandler::operator=(x);
	setVUdp(x.mVUdp);
	setDUdp(x.mDUdp);
	return *this;
}
 
RRStatus IARootHandler::mfChangeBGColorAction()
{
	mVUdp->changeBGColor();
	mVUdp->onDraw();
	return RR_SUCCESS;
}

RRStatus IARootHandler::mfAddMatchingPointAction(
			const RREvent& e)
{
	IAMatchingPoint *mp = new IAMatchingPoint(e.pos,IAMP_D_WIDTH);
	mDUdp->addMatchingPoint(mp);
	
	IAMobileRect *mr = new IAMobileRect(mp);
	mVUdp->addMobileRect(mr);
	mr->changeColorSelected();

	IAMobileRectHandler *mrh = new IAMobileRectHandler(this,
													   mp,
													   mr,						
													   mVUdp);
	mfSetLocking(mrh);
	mVUdp->onDraw();
	return RR_SUCCESS;
}
    
RRStatus IARootHandler::mfRemoveMatchingPointAction(
			const RREvent& e)
{
	int nc=mfGetNumChildren();
	for(int i=0;i<nc;i++)
	{
		RREventHandler *mrh=mfGetChild(i);
		if(mrh->getBBox().isHit(e.pos))
		{
			IAMatchingPoint *mp=((IAMobileRectHandler*)mrh)->getMatchingPoint();
			mDUdp->removeMatchingPoint(mp);
			delete mp;

			IAMobileRect *mr=((IAMobileRectHandler*)mrh)->getGraphic();
			mVUdp->removeMobileRect(mr);
			delete mr;
			
			delete mrh;
			break;
		}
	}

	mfSetLocking(NULL);
	mVUdp->onDraw();
	return RR_UNLOCKED;
}

//-------------------------------------------------------------------=72
// End of IARootHandler.cpp
//-------------------------------------------------------------------=72
